// pathdlg.h - defines path dialog class - path_dialog
//    Copyright (C) 2000 Laurynas Biveinis <lauras@softhome.net>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#ifndef LBINSTDJ_H_
#define LBINSTDJ_H

#include "global.h"

#ifdef HAVE_TV_H
#  define Uses_TDialog
#  define Uses_TEvent
#  define Uses_TValidator
#  include <tv.h>
#endif

class path_dialog : public TDialog
{
   public:
      path_dialog(const char *title, const char *prompt, const char * def_dir,
                  int is_new_button);
      virtual void handleEvent(TEvent & event);
      bool get_path(char * path);

   protected:
      virtual TValidator * set_validator(void);

   private:
      int new_button;
};

class djgpp_dir_dialog : public path_dialog
{
   public:
      djgpp_dir_dialog(void);

   protected:
      virtual TValidator * set_validator(void);

   private:
      class dj_path_validator : public TValidator
      {
          public:
              virtual void    Error(void);
              virtual Boolean IsValid(const char * path);
      };
};

class zip_path_dialog : public path_dialog
{
   public:
      zip_path_dialog(void);
};

#endif
