/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.ByteArrayInputStream;
import java.util.Optional;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.ReportLoader;
import net.sf.jasperreports.jackson.util.JacksonUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JacksonReportLoader
implements ReportLoader {
    private static final Log log = LogFactory.getLog(JacksonReportLoader.class);
    private static final JacksonReportLoader INSTANCE = new JacksonReportLoader();

    public static JacksonReportLoader instance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<JasperDesign> loadReport(JasperReportsContext context, byte[] data) throws JRException {
        boolean detectedReport = this.detectReportXML(data);
        if (detectedReport) {
            JasperDesign report = null;
            ByteArrayInputStream dataStream = new ByteArrayInputStream(data);
            JasperDesign.setThreadJasperReportsContext(context);
            try {
                report = JacksonUtil.getInstance(context).loadXml(dataStream, JasperDesign.class);
            }
            finally {
                JasperDesign.removeThreadJasperReportsContext();
                JasperDesign.removeThreadInstance();
            }
            return Optional.of(report);
        }
        return Optional.empty();
    }

    protected boolean detectReportXML(byte[] data) {
        return this.detectRootElement(data, "jasperReport");
    }

    @Override
    public Optional<JRTemplate> loadTemplate(JasperReportsContext context, byte[] data) {
        boolean detectedReport = this.detectTemplateXML(data);
        if (detectedReport) {
            ByteArrayInputStream dataStream = new ByteArrayInputStream(data);
            JRSimpleTemplate template = JacksonUtil.getInstance(context).loadXml(dataStream, JRSimpleTemplate.class);
            return Optional.of(template);
        }
        return Optional.empty();
    }

    private boolean detectTemplateXML(byte[] data) {
        return this.detectRootElement(data, "jasperTemplate");
    }

    protected boolean detectRootElement(byte[] data, String elementName) {
        ByteArrayInputStream dataStream = new ByteArrayInputStream(data);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(dataStream);
            boolean foundRoot = false;
            boolean ended = false;
            block5: while (!ended && reader.hasNext()) {
                reader.next();
                switch (reader.getEventType()) {
                    case 1: {
                        if (!elementName.equals(reader.getLocalName()) || reader.getNamespaceURI() != null && !reader.getNamespaceURI().isEmpty()) break block5;
                        foundRoot = true;
                        break block5;
                    }
                    default: {
                        continue block5;
                    }
                }
            }
            return foundRoot;
        }
        catch (XMLStreamException e) {
            log.debug((Object)("failed to load jrxml " + e));
            return false;
        }
    }
}

