/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.bk;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class LedgerMetadata {
    private String application;
    private String component;
    private Map<String, String> customMetadata;

    public void setApplication(String application) {
        this.application = application;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void addCustomMetadata(String key, String value) {
        if (key == null || "".equals(key.trim())) {
            throw new IllegalArgumentException("Metadata key cant be empty");
        }
        if (value == null || "".equals(value.trim())) {
            throw new IllegalArgumentException("Metadata value cant be empty");
        }
        if (this.customMetadata == null) {
            this.customMetadata = new HashMap<String, String>();
        }
        this.customMetadata.put(key, value);
    }

    public Map<String, byte[]> getMetadata() {
        HashMap<String, byte[]> meta = new HashMap<String, byte[]>();
        if (this.application != null) {
            meta.put("application", this.application.getBytes(StandardCharsets.UTF_8));
        }
        if (this.component != null) {
            meta.put("component", this.component.getBytes(StandardCharsets.UTF_8));
        }
        if (this.customMetadata != null) {
            for (Map.Entry<String, String> e : this.customMetadata.entrySet()) {
                String value = e.getValue();
                meta.put(e.getKey(), value.getBytes(StandardCharsets.UTF_8));
            }
        }
        return meta;
    }
}

