/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.apimachinery;

import io.kubernetes.client.apimachinery.GroupVersion;
import io.kubernetes.client.util.Preconditions;
import java.util.Objects;

public class GroupVersionKind
extends GroupVersion {
    private final String kind;

    public GroupVersionKind(String group, String version, String kind) {
        super(group, version);
        this.kind = Preconditions.precondition(kind, Objects::isNull, () -> "kind must not be null");
    }

    public String getKind() {
        return this.kind;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupVersionKind that = (GroupVersionKind)o;
        return Objects.equals(this.kind, that.kind);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.kind);
    }
}

