/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.opentelemetry.api.common.Attributes;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.LookupService;
import org.apache.pulsar.client.impl.LookupTopicResult;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.PulsarServiceNameResolver;
import org.apache.pulsar.client.impl.ServiceNameResolver;
import org.apache.pulsar.client.impl.metrics.LatencyHistogram;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.api.proto.CommandLookupTopicResponse;
import org.apache.pulsar.common.lookup.GetTopicsResult;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.util.Backoff;
import org.apache.pulsar.common.util.BackoffBuilder;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryProtoLookupService
implements LookupService {
    private final PulsarClientImpl client;
    private final ServiceNameResolver serviceNameResolver;
    private final boolean useTls;
    private final ExecutorService scheduleExecutor;
    private final String listenerName;
    private final int maxLookupRedirects;
    private final ExecutorService lookupPinnedExecutor;
    private final boolean createdLookupPinnedExecutor;
    private final ConcurrentHashMap<Pair<TopicName, Map<String, String>>, CompletableFuture<LookupTopicResult>> lookupInProgress = new ConcurrentHashMap();
    private final ConcurrentHashMap<TopicName, CompletableFuture<PartitionedTopicMetadata>> partitionedMetadataInProgress = new ConcurrentHashMap();
    private final LatencyHistogram histoGetBroker;
    private final LatencyHistogram histoGetTopicMetadata;
    private final LatencyHistogram histoGetSchema;
    private final LatencyHistogram histoListTopics;
    private static final Logger log = LoggerFactory.getLogger(BinaryProtoLookupService.class);

    @Deprecated
    public BinaryProtoLookupService(PulsarClientImpl client, String serviceUrl, boolean useTls, ExecutorService scheduleExecutor) throws PulsarClientException {
        this(client, serviceUrl, null, useTls, scheduleExecutor);
    }

    @Deprecated
    public BinaryProtoLookupService(PulsarClientImpl client, String serviceUrl, String listenerName, boolean useTls, ExecutorService scheduleExecutor) throws PulsarClientException {
        this(client, serviceUrl, listenerName, useTls, scheduleExecutor, null);
    }

    public BinaryProtoLookupService(PulsarClientImpl client, String serviceUrl, String listenerName, boolean useTls, ExecutorService scheduleExecutor, ExecutorService lookupPinnedExecutor) throws PulsarClientException {
        this.client = client;
        this.useTls = useTls;
        this.scheduleExecutor = scheduleExecutor;
        this.maxLookupRedirects = client.getConfiguration().getMaxLookupRedirects();
        this.serviceNameResolver = new PulsarServiceNameResolver(client.getConfiguration().getServiceUrlQuarantineInitDurationMs(), client.getConfiguration().getServiceUrlQuarantineMaxDurationMs());
        this.listenerName = listenerName;
        this.updateServiceUrl(serviceUrl);
        LatencyHistogram histo = client.instrumentProvider().newLatencyHistogram("pulsar.client.lookup.duration", "Duration of lookup operations", null, Attributes.builder().put("pulsar.lookup.transport-type", "binary").build());
        this.histoGetBroker = histo.withAttributes(Attributes.builder().put("pulsar.lookup.type", "topic").build());
        this.histoGetTopicMetadata = histo.withAttributes(Attributes.builder().put("pulsar.lookup.type", "metadata").build());
        this.histoGetSchema = histo.withAttributes(Attributes.builder().put("pulsar.lookup.type", "schema").build());
        this.histoListTopics = histo.withAttributes(Attributes.builder().put("pulsar.lookup.type", "list-topics").build());
        if (lookupPinnedExecutor == null) {
            this.createdLookupPinnedExecutor = true;
            this.lookupPinnedExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("pulsar-client-binary-proto-lookup"));
        } else {
            this.createdLookupPinnedExecutor = false;
            this.lookupPinnedExecutor = lookupPinnedExecutor;
        }
    }

    @Override
    public void updateServiceUrl(String serviceUrl) throws PulsarClientException {
        this.serviceNameResolver.updateServiceUrl(serviceUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<LookupTopicResult> getBroker(TopicName topicName) {
        long startTime = System.nanoTime();
        MutableObject newFutureCreated = new MutableObject();
        Pair key = Pair.of((Object)topicName, this.client.getConfiguration().getLookupProperties());
        try {
            CompletableFuture completableFuture = this.lookupInProgress.computeIfAbsent((Pair<TopicName, Map<String, String>>)key, tpName -> {
                CompletableFuture<LookupTopicResult> newFuture = this.findBroker(this.serviceNameResolver.resolveHost(), false, topicName, 0, (Map)key.getRight());
                newFutureCreated.setValue(newFuture);
                ((CompletableFuture)newFuture.thenRun(() -> this.histoGetBroker.recordSuccess(System.nanoTime() - startTime))).exceptionally(x -> {
                    this.histoGetBroker.recordFailure(System.nanoTime() - startTime);
                    return null;
                });
                return newFuture;
            });
            return completableFuture;
        }
        finally {
            if (newFutureCreated.getValue() != null) {
                ((CompletableFuture)newFutureCreated.getValue()).whenComplete((v, ex) -> this.lookupInProgress.remove(key, newFutureCreated.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadata(TopicName topicName, boolean metadataAutoCreationEnabled, boolean useFallbackForNonPIP344Brokers) {
        MutableObject newFutureCreated = new MutableObject();
        try {
            CompletableFuture completableFuture = this.partitionedMetadataInProgress.computeIfAbsent(topicName, tpName -> {
                CompletableFuture<PartitionedTopicMetadata> newFuture = this.getPartitionedTopicMetadataAsync(topicName, metadataAutoCreationEnabled, useFallbackForNonPIP344Brokers);
                newFutureCreated.setValue(newFuture);
                return newFuture;
            });
            return completableFuture;
        }
        finally {
            if (newFutureCreated.getValue() != null) {
                ((CompletableFuture)newFutureCreated.getValue()).whenComplete((v, ex) -> this.partitionedMetadataInProgress.remove(topicName, newFutureCreated.getValue()));
            }
        }
    }

    private CompletableFuture<LookupTopicResult> findBroker(InetSocketAddress socketAddress, boolean authoritative, TopicName topicName, int redirectCount, Map<String, String> properties) {
        CompletableFuture<LookupTopicResult> addressFuture = new CompletableFuture<LookupTopicResult>();
        if (this.maxLookupRedirects > 0 && redirectCount > this.maxLookupRedirects) {
            addressFuture.completeExceptionally((Throwable)new PulsarClientException.LookupException("Too many redirects: " + this.maxLookupRedirects));
            return addressFuture;
        }
        ((CompletableFuture)this.client.getCnxPool().getConnection(socketAddress).thenAcceptAsync(clientCnx -> {
            long requestId = this.client.newRequestId();
            ByteBuf request = Commands.newLookup((String)topicName.toString(), (String)this.listenerName, (boolean)authoritative, (long)requestId, (Map)properties);
            clientCnx.newLookup(request, requestId).whenComplete((r, t) -> {
                if (t != null) {
                    log.warn("[{}] failed to send lookup request : {}", (Object)topicName, (Object)t.getMessage());
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Lookup response exception: {}", (Object)topicName, t);
                    }
                    addressFuture.completeExceptionally((Throwable)t);
                } else {
                    URI uri = null;
                    try {
                        if (this.useTls) {
                            uri = new URI(r.brokerUrlTls);
                        } else {
                            String serviceUrl = r.brokerUrl;
                            uri = new URI(serviceUrl);
                        }
                        InetSocketAddress responseBrokerAddress = InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
                        if (r.redirect) {
                            ((CompletableFuture)this.findBroker(responseBrokerAddress, r.authoritative, topicName, redirectCount + 1, properties).thenAccept(addressFuture::complete)).exceptionally(lookupException -> {
                                Throwable cause = FutureUtil.unwrapCompletionException((Throwable)lookupException);
                                if (redirectCount > 0) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("[{}] lookup redirection failed ({}) : {}", new Object[]{topicName, redirectCount, cause.getMessage()});
                                    }
                                } else {
                                    log.warn("[{}] lookup failed : {}", new Object[]{topicName, cause.getMessage(), cause});
                                }
                                addressFuture.completeExceptionally(cause);
                                return null;
                            });
                        } else if (r.proxyThroughServiceUrl) {
                            addressFuture.complete(new LookupTopicResult(responseBrokerAddress, socketAddress, true));
                        } else {
                            addressFuture.complete(new LookupTopicResult(responseBrokerAddress, responseBrokerAddress, false));
                        }
                    }
                    catch (Exception parseUrlException) {
                        log.warn("[{}] invalid url {} : {}", new Object[]{topicName, uri, parseUrlException.getMessage(), parseUrlException});
                        addressFuture.completeExceptionally(parseUrlException);
                    }
                }
                this.client.getCnxPool().releaseConnection((ClientCnx)((Object)clientCnx));
            });
        }, (Executor)this.lookupPinnedExecutor)).exceptionally(connectionException -> {
            this.serviceNameResolver.markHostAvailability(socketAddress, false);
            addressFuture.completeExceptionally(FutureUtil.unwrapCompletionException((Throwable)connectionException));
            return null;
        });
        return addressFuture;
    }

    private CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadataAsync(TopicName topicName, boolean metadataAutoCreationEnabled, boolean useFallbackForNonPIP344Brokers) {
        long startTime = System.nanoTime();
        CompletableFuture<PartitionedTopicMetadata> partitionFuture = new CompletableFuture<PartitionedTopicMetadata>();
        ((CompletableFuture)this.client.getCnxPool().getConnection(this.serviceNameResolver).thenAcceptAsync(clientCnx -> {
            boolean finalAutoCreationEnabled = metadataAutoCreationEnabled;
            if (!metadataAutoCreationEnabled && !clientCnx.isSupportsGetPartitionedMetadataWithoutAutoCreation()) {
                if (useFallbackForNonPIP344Brokers) {
                    log.info("[{}] Using original behavior of getPartitionedTopicMetadata(topic) in getPartitionedTopicMetadata(topic, false) since the target broker does not support PIP-344 and fallback is enabled.", (Object)topicName);
                    finalAutoCreationEnabled = true;
                } else {
                    partitionFuture.completeExceptionally((Throwable)new PulsarClientException.FeatureNotSupportedException("The feature of getting partitions without auto-creation is not supported by the broker. Please upgrade the broker to version that supports PIP-344 to resolve this issue.", PulsarClientException.FailedFeatureCheck.SupportsGetPartitionedMetadataWithoutAutoCreation));
                    return;
                }
            }
            long requestId = this.client.newRequestId();
            ByteBuf request = Commands.newPartitionMetadataRequest((String)topicName.toString(), (long)requestId, (boolean)finalAutoCreationEnabled);
            clientCnx.newLookup(request, requestId).whenComplete((r, t) -> {
                if (t != null) {
                    this.histoGetTopicMetadata.recordFailure(System.nanoTime() - startTime);
                    log.warn("[{}] failed to get Partitioned metadata : {}", new Object[]{topicName, t.getMessage(), t});
                    partitionFuture.completeExceptionally((Throwable)t);
                } else {
                    try {
                        this.histoGetTopicMetadata.recordSuccess(System.nanoTime() - startTime);
                        partitionFuture.complete(new PartitionedTopicMetadata(r.partitions));
                    }
                    catch (Exception e) {
                        partitionFuture.completeExceptionally((Throwable)new PulsarClientException.LookupException(String.format("Failed to parse partition-response redirect=%s, topic=%s, partitions with %s, error message %s", r.redirect, topicName, r.partitions, e.getMessage())));
                    }
                }
                this.client.getCnxPool().releaseConnection((ClientCnx)((Object)clientCnx));
            });
        }, (Executor)this.lookupPinnedExecutor)).exceptionally(connectionException -> {
            partitionFuture.completeExceptionally(FutureUtil.unwrapCompletionException((Throwable)connectionException));
            return null;
        });
        return partitionFuture;
    }

    @Override
    public CompletableFuture<Optional<SchemaInfo>> getSchema(TopicName topicName) {
        return this.getSchema(topicName, null);
    }

    @Override
    public CompletableFuture<Optional<SchemaInfo>> getSchema(TopicName topicName, byte[] version) {
        long startTime = System.nanoTime();
        CompletableFuture<Optional<SchemaInfo>> schemaFuture = new CompletableFuture<Optional<SchemaInfo>>();
        if (version != null && version.length == 0) {
            schemaFuture.completeExceptionally((Throwable)new SchemaSerializationException("Empty schema version"));
            return schemaFuture;
        }
        ((CompletableFuture)this.client.getCnxPool().getConnection(this.serviceNameResolver).thenAcceptAsync(clientCnx -> {
            long requestId = this.client.newRequestId();
            ByteBuf request = Commands.newGetSchema((long)requestId, (String)topicName.toString(), Optional.ofNullable(BytesSchemaVersion.of((byte[])version)));
            clientCnx.sendGetSchema(request, requestId).whenComplete((r, t) -> {
                if (t != null) {
                    this.histoGetSchema.recordFailure(System.nanoTime() - startTime);
                    log.warn("[{}] failed to get schema : {}", new Object[]{topicName, t.getMessage(), t});
                    schemaFuture.completeExceptionally((Throwable)t);
                } else {
                    this.histoGetSchema.recordSuccess(System.nanoTime() - startTime);
                    schemaFuture.complete((Optional<SchemaInfo>)r);
                }
                this.client.getCnxPool().releaseConnection((ClientCnx)((Object)clientCnx));
            });
        }, (Executor)this.lookupPinnedExecutor)).exceptionally(ex -> {
            schemaFuture.completeExceptionally(FutureUtil.unwrapCompletionException((Throwable)ex));
            return null;
        });
        return schemaFuture;
    }

    @Override
    public String getServiceUrl() {
        return this.serviceNameResolver.getServiceUrl();
    }

    @Override
    public InetSocketAddress resolveHost() {
        return this.serviceNameResolver.resolveHost();
    }

    @Override
    public CompletableFuture<GetTopicsResult> getTopicsUnderNamespace(NamespaceName namespace, CommandGetTopicsOfNamespace.Mode mode, String topicsPattern, String topicsHash) {
        CompletableFuture<GetTopicsResult> topicsFuture = new CompletableFuture<GetTopicsResult>();
        AtomicLong opTimeoutMs = new AtomicLong(this.client.getConfiguration().getOperationTimeoutMs());
        Backoff backoff = new BackoffBuilder().setInitialTime(100L, TimeUnit.MILLISECONDS).setMandatoryStop(opTimeoutMs.get() * 2L, TimeUnit.MILLISECONDS).setMax(1L, TimeUnit.MINUTES).create();
        this.getTopicsUnderNamespace(namespace, backoff, opTimeoutMs, topicsFuture, mode, topicsPattern, topicsHash);
        return topicsFuture;
    }

    private void getTopicsUnderNamespace(NamespaceName namespace, Backoff backoff, AtomicLong remainingTime, CompletableFuture<GetTopicsResult> getTopicsResultFuture, CommandGetTopicsOfNamespace.Mode mode, String topicsPattern, String topicsHash) {
        long startTime = System.nanoTime();
        ((CompletableFuture)this.client.getCnxPool().getConnection(this.serviceNameResolver).thenAcceptAsync(clientCnx -> {
            long requestId = this.client.newRequestId();
            ByteBuf request = Commands.newGetTopicsOfNamespaceRequest((String)namespace.toString(), (long)requestId, (CommandGetTopicsOfNamespace.Mode)mode, (String)topicsPattern, (String)topicsHash);
            clientCnx.newGetTopicsOfNamespace(request, requestId).whenComplete((r, t) -> {
                if (t != null) {
                    this.histoListTopics.recordFailure(System.nanoTime() - startTime);
                    getTopicsResultFuture.completeExceptionally((Throwable)t);
                } else {
                    this.histoListTopics.recordSuccess(System.nanoTime() - startTime);
                    if (log.isDebugEnabled()) {
                        log.debug("[namespace: {}] Success get topics list in request: {}", (Object)namespace, (Object)requestId);
                    }
                    getTopicsResultFuture.complete((GetTopicsResult)r);
                }
                this.client.getCnxPool().releaseConnection((ClientCnx)((Object)clientCnx));
            });
        }, (Executor)this.lookupPinnedExecutor)).exceptionally(e -> {
            long nextDelay = Math.min(backoff.next(), remainingTime.get());
            if (nextDelay <= 0L) {
                getTopicsResultFuture.completeExceptionally((Throwable)new PulsarClientException.TimeoutException(String.format("Could not get topics of namespace %s within configured timeout", namespace.toString())));
                return null;
            }
            ((ScheduledExecutorService)this.scheduleExecutor).schedule(() -> {
                log.warn("[namespace: {}] Could not get connection while getTopicsUnderNamespace -- Will try again in {} ms", (Object)namespace, (Object)nextDelay);
                remainingTime.addAndGet(-nextDelay);
                this.getTopicsUnderNamespace(namespace, backoff, remainingTime, getTopicsResultFuture, mode, topicsPattern, topicsHash);
            }, nextDelay, TimeUnit.MILLISECONDS);
            return null;
        });
    }

    @Override
    public void close() throws Exception {
        if (this.createdLookupPinnedExecutor && this.lookupPinnedExecutor != null && !this.lookupPinnedExecutor.isShutdown()) {
            this.lookupPinnedExecutor.shutdown();
        }
    }

    public static class LookupDataResult {
        public final String brokerUrl;
        public final String brokerUrlTls;
        public final int partitions;
        public final boolean authoritative;
        public final boolean proxyThroughServiceUrl;
        public final boolean redirect;

        public LookupDataResult(CommandLookupTopicResponse result) {
            this.brokerUrl = result.hasBrokerServiceUrl() ? result.getBrokerServiceUrl() : null;
            this.brokerUrlTls = result.hasBrokerServiceUrlTls() ? result.getBrokerServiceUrlTls() : null;
            this.authoritative = result.isAuthoritative();
            this.redirect = result.hasResponse() && result.getResponse() == CommandLookupTopicResponse.LookupType.Redirect;
            this.proxyThroughServiceUrl = result.isProxyThroughServiceUrl();
            this.partitions = -1;
        }

        public LookupDataResult(int partitions) {
            this.partitions = partitions;
            this.brokerUrl = null;
            this.brokerUrlTls = null;
            this.authoritative = false;
            this.proxyThroughServiceUrl = false;
            this.redirect = false;
        }
    }
}

