/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.util.RestException;

public class PoliciesUtil {
    private static final long MAX_BUNDLES = 0x100000000L;

    public static BundlesData defaultBundle() {
        ArrayList<String> boundaries = new ArrayList<String>();
        boundaries.add("0x00000000");
        boundaries.add("0xffffffff");
        return BundlesData.builder().numBundles(1).boundaries(boundaries).build();
    }

    public static void setStorageQuota(Policies polices, BacklogQuota quota) {
        if (polices == null) {
            return;
        }
        polices.backlog_quota_map.put(BacklogQuota.BacklogQuotaType.destination_storage, quota);
    }

    public static BundlesData getBundles(int numBundles) {
        if (numBundles <= 0) {
            throw new RestException(Response.Status.BAD_REQUEST, "Invalid number of bundles. Number of bundles has to be in the range of (0, 2^32].");
        }
        Long maxVal = 0x100000000L;
        Long segSize = maxVal / (long)numBundles;
        ArrayList<String> partitions = new ArrayList<String>();
        partitions.add(String.format("0x%08x", 0L));
        Long curPartition = segSize;
        for (int i = 0; i < numBundles; ++i) {
            if (i != numBundles - 1) {
                partitions.add(String.format("0x%08x", curPartition));
            } else {
                partitions.add(String.format("0x%08x", maxVal - 1L));
            }
            curPartition = curPartition + segSize;
        }
        return BundlesData.builder().boundaries(partitions).numBundles(numBundles).build();
    }
}

