/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.MoreObjects;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.WindowFrame;
import java.util.Objects;
import java.util.Optional;

public class FrameInfo {
    private final WindowFrame.Type type;
    private final FrameBound.Type startType;
    private final int startChannel;
    private final int sortKeyChannelForStartComparison;
    private final FrameBound.Type endType;
    private final int endChannel;
    private final int sortKeyChannelForEndComparison;
    private final int sortKeyChannel;
    private final Optional<SortItem.Ordering> ordering;

    public FrameInfo(WindowFrame.Type type, FrameBound.Type startType, Optional<Integer> startChannel, Optional<Integer> sortKeyChannelForStartComparison, FrameBound.Type endType, Optional<Integer> endChannel, Optional<Integer> sortKeyChannelForEndComparison, Optional<Integer> sortKeyChannel, Optional<SortItem.Ordering> ordering) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.startType = Objects.requireNonNull(startType, "startType is null");
        this.startChannel = Objects.requireNonNull(startChannel, "startChannel is null").orElse(-1);
        this.sortKeyChannelForStartComparison = Objects.requireNonNull(sortKeyChannelForStartComparison, "sortKeyChannelForStartComparison is null").orElse(-1);
        this.endType = Objects.requireNonNull(endType, "endType is null");
        this.endChannel = Objects.requireNonNull(endChannel, "endChannel is null").orElse(-1);
        this.sortKeyChannelForEndComparison = Objects.requireNonNull(sortKeyChannelForEndComparison, "sortKeyChannelForEndComparison is null").orElse(-1);
        this.sortKeyChannel = Objects.requireNonNull(sortKeyChannel, "sortKeyChannel is null").orElse(-1);
        this.ordering = Objects.requireNonNull(ordering, "ordering is null");
    }

    public WindowFrame.Type getType() {
        return this.type;
    }

    public FrameBound.Type getStartType() {
        return this.startType;
    }

    public int getStartChannel() {
        return this.startChannel;
    }

    public int getSortKeyChannelForStartComparison() {
        return this.sortKeyChannelForStartComparison;
    }

    public FrameBound.Type getEndType() {
        return this.endType;
    }

    public int getEndChannel() {
        return this.endChannel;
    }

    public int getSortKeyChannelForEndComparison() {
        return this.sortKeyChannelForEndComparison;
    }

    public int getSortKeyChannel() {
        return this.sortKeyChannel;
    }

    public Optional<SortItem.Ordering> getOrdering() {
        return this.ordering;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.startType, this.startChannel, this.sortKeyChannelForStartComparison, this.endType, this.endChannel, this.sortKeyChannelForEndComparison, this.sortKeyChannel, this.ordering);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FrameInfo other = (FrameInfo)obj;
        return this.type == other.type && this.startType == other.startType && Objects.equals(this.startChannel, other.startChannel) && Objects.equals(this.sortKeyChannelForStartComparison, other.sortKeyChannelForStartComparison) && this.endType == other.endType && Objects.equals(this.endChannel, other.endChannel) && Objects.equals(this.sortKeyChannelForEndComparison, other.sortKeyChannelForEndComparison) && Objects.equals(this.sortKeyChannel, other.sortKeyChannel) && Objects.equals(this.ordering, other.ordering);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("startType", (Object)this.startType).add("startChannel", this.startChannel).add("sortKeyChannelForStartComparison", this.sortKeyChannelForStartComparison).add("endType", (Object)this.endType).add("endChannel", this.endChannel).add("sortKeyChannelForEndComparison", this.sortKeyChannelForEndComparison).add("sortKeyChannel", this.sortKeyChannel).add("ordering", this.ordering).toString();
    }
}

