/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetSchemaAuthorization;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SetSchemaAuthorizationTask
implements DataDefinitionTask<SetSchemaAuthorization> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public SetSchemaAuthorizationTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "SET SCHEMA AUTHORIZATION";
    }

    @Override
    public ListenableFuture<Void> execute(SetSchemaAuthorization statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        CatalogSchemaName source;
        Session session = stateMachine.getSession();
        if (!this.metadata.schemaExists(session, source = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSource())))) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)statement, "Schema '%s' does not exist", source);
        }
        TrinoPrincipal principal = MetadataUtil.createPrincipal(statement.getPrincipal());
        MetadataUtil.checkRoleExists(session, (Node)statement, this.metadata, principal, Optional.of(source.getCatalogName()).filter(catalog -> this.metadata.isCatalogManagedSecurity(session, (String)catalog)));
        this.accessControl.checkCanSetSchemaAuthorization(session.toSecurityContext(), source, principal);
        this.metadata.setSchemaAuthorization(session, source, principal);
        return Futures.immediateVoidFuture();
    }
}

