/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.avro;

import com.google.common.collect.ImmutableMap;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.avro.AvroColumnDecoder;
import io.trino.decoder.avro.AvroDeserializer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class SingleValueRowDecoder
implements RowDecoder {
    private final DecoderColumnHandle column;
    private final AvroDeserializer<Object> deserializer;

    public SingleValueRowDecoder(AvroDeserializer<Object> deserializer, DecoderColumnHandle column) {
        this.deserializer = Objects.requireNonNull(deserializer, "deserializer is null");
        this.column = Objects.requireNonNull(column, "columns is null");
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(byte[] data, Map<String, String> dataMap) {
        Object avroValue = this.deserializer.deserialize(data);
        return Optional.of(ImmutableMap.of((Object)this.column, (Object)new AvroColumnDecoder.ObjectValueProvider(avroValue, this.column.getType(), this.column.getName())));
    }
}

