/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesVariableBuild {
  BuildInfoType_ProductUri((int) 3052L),
  BuildInfoType_ManufacturerName((int) 3053L),
  BuildInfoType_ProductName((int) 3054L),
  BuildInfoType_SoftwareVersion((int) 3055L),
  BuildInfoType_BuildNumber((int) 3056L),
  BuildInfoType_BuildDate((int) 3057L);
  private static final Map<Integer, OpcuaNodeIdServicesVariableBuild> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesVariableBuild value : OpcuaNodeIdServicesVariableBuild.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesVariableBuild(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesVariableBuild enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
