/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * CommDatalayerPropertyRule
 */
@JsonPropertyOrder({
  CommDatalayerPropertyRule.JSON_PROPERTY_SAMPLING_INTERVAL,
  CommDatalayerPropertyRule.JSON_PROPERTY_QUEUE_SIZE,
  CommDatalayerPropertyRule.JSON_PROPERTY_BEHAVIOUR,
  CommDatalayerPropertyRule.JSON_PROPERTY_DEAD_BAND_VALUE,
  CommDatalayerPropertyRule.JSON_PROPERTY_VALUE_CHANGE,
  CommDatalayerPropertyRule.JSON_PROPERTY_BROWSELIST_CHANGE,
  CommDatalayerPropertyRule.JSON_PROPERTY_METADATA_CHANGE,
  CommDatalayerPropertyRule.JSON_PROPERTY_COUNT_SUBSCRIPTIONS
})
@JsonTypeName("comm_datalayer_Property_rule")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class CommDatalayerPropertyRule {
  public static final String JSON_PROPERTY_SAMPLING_INTERVAL = "samplingInterval";
  private Integer samplingInterval = 1000000;

  public static final String JSON_PROPERTY_QUEUE_SIZE = "queueSize";
  private Integer queueSize = 10;

  public static final String JSON_PROPERTY_BEHAVIOUR = "behaviour";
  private CommDatalayerQueueBehaviour behaviour;

  public static final String JSON_PROPERTY_DEAD_BAND_VALUE = "deadBandValue";
  private BigDecimal deadBandValue;

  public static final String JSON_PROPERTY_VALUE_CHANGE = "valueChange";
  private CommDatalayerDataChangeTrigger valueChange;

  public static final String JSON_PROPERTY_BROWSELIST_CHANGE = "browselistChange";
  private Boolean browselistChange;

  public static final String JSON_PROPERTY_METADATA_CHANGE = "metadataChange";
  private Boolean metadataChange;

  public static final String JSON_PROPERTY_COUNT_SUBSCRIPTIONS = "countSubscriptions";
  private Boolean countSubscriptions;

  public CommDatalayerPropertyRule() {
  }

  public CommDatalayerPropertyRule samplingInterval(Integer samplingInterval) {
    
    this.samplingInterval = samplingInterval;
    return this;
  }

   /**
   * sample time in µ seconds for minimum sampling of data - currently only multiples of 1000 are supported
   * minimum: 0
   * maximum: 384
   * @return samplingInterval
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SAMPLING_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSamplingInterval() {
    return samplingInterval;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLING_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSamplingInterval(Integer samplingInterval) {
    this.samplingInterval = samplingInterval;
  }


  public CommDatalayerPropertyRule queueSize(Integer queueSize) {
    
    this.queueSize = queueSize;
    return this;
  }

   /**
   * size of buffer
   * minimum: 0
   * maximum: 4294967295
   * @return queueSize
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_QUEUE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQueueSize() {
    return queueSize;
  }


  @JsonProperty(JSON_PROPERTY_QUEUE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQueueSize(Integer queueSize) {
    this.queueSize = queueSize;
  }


  public CommDatalayerPropertyRule behaviour(CommDatalayerQueueBehaviour behaviour) {
    
    this.behaviour = behaviour;
    return this;
  }

   /**
   * Get behaviour
   * @return behaviour
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BEHAVIOUR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CommDatalayerQueueBehaviour getBehaviour() {
    return behaviour;
  }


  @JsonProperty(JSON_PROPERTY_BEHAVIOUR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBehaviour(CommDatalayerQueueBehaviour behaviour) {
    this.behaviour = behaviour;
  }


  public CommDatalayerPropertyRule deadBandValue(BigDecimal deadBandValue) {
    
    this.deadBandValue = deadBandValue;
    return this;
  }

   /**
   * Get deadBandValue
   * @return deadBandValue
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEAD_BAND_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDeadBandValue() {
    return deadBandValue;
  }


  @JsonProperty(JSON_PROPERTY_DEAD_BAND_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeadBandValue(BigDecimal deadBandValue) {
    this.deadBandValue = deadBandValue;
  }


  public CommDatalayerPropertyRule valueChange(CommDatalayerDataChangeTrigger valueChange) {
    
    this.valueChange = valueChange;
    return this;
  }

   /**
   * Get valueChange
   * @return valueChange
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUE_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CommDatalayerDataChangeTrigger getValueChange() {
    return valueChange;
  }


  @JsonProperty(JSON_PROPERTY_VALUE_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValueChange(CommDatalayerDataChangeTrigger valueChange) {
    this.valueChange = valueChange;
  }


  public CommDatalayerPropertyRule browselistChange(Boolean browselistChange) {
    
    this.browselistChange = browselistChange;
    return this;
  }

   /**
   * Get browselistChange
   * @return browselistChange
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BROWSELIST_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getBrowselistChange() {
    return browselistChange;
  }


  @JsonProperty(JSON_PROPERTY_BROWSELIST_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrowselistChange(Boolean browselistChange) {
    this.browselistChange = browselistChange;
  }


  public CommDatalayerPropertyRule metadataChange(Boolean metadataChange) {
    
    this.metadataChange = metadataChange;
    return this;
  }

   /**
   * Get metadataChange
   * @return metadataChange
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMetadataChange() {
    return metadataChange;
  }


  @JsonProperty(JSON_PROPERTY_METADATA_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadataChange(Boolean metadataChange) {
    this.metadataChange = metadataChange;
  }


  public CommDatalayerPropertyRule countSubscriptions(Boolean countSubscriptions) {
    
    this.countSubscriptions = countSubscriptions;
    return this;
  }

   /**
   * Get countSubscriptions
   * @return countSubscriptions
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COUNT_SUBSCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCountSubscriptions() {
    return countSubscriptions;
  }


  @JsonProperty(JSON_PROPERTY_COUNT_SUBSCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountSubscriptions(Boolean countSubscriptions) {
    this.countSubscriptions = countSubscriptions;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommDatalayerPropertyRule commDatalayerPropertyRule = (CommDatalayerPropertyRule) o;
    return Objects.equals(this.samplingInterval, commDatalayerPropertyRule.samplingInterval) &&
        Objects.equals(this.queueSize, commDatalayerPropertyRule.queueSize) &&
        Objects.equals(this.behaviour, commDatalayerPropertyRule.behaviour) &&
        Objects.equals(this.deadBandValue, commDatalayerPropertyRule.deadBandValue) &&
        Objects.equals(this.valueChange, commDatalayerPropertyRule.valueChange) &&
        Objects.equals(this.browselistChange, commDatalayerPropertyRule.browselistChange) &&
        Objects.equals(this.metadataChange, commDatalayerPropertyRule.metadataChange) &&
        Objects.equals(this.countSubscriptions, commDatalayerPropertyRule.countSubscriptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(samplingInterval, queueSize, behaviour, deadBandValue, valueChange, browselistChange, metadataChange, countSubscriptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommDatalayerPropertyRule {\n");
    sb.append("    samplingInterval: ").append(toIndentedString(samplingInterval)).append("\n");
    sb.append("    queueSize: ").append(toIndentedString(queueSize)).append("\n");
    sb.append("    behaviour: ").append(toIndentedString(behaviour)).append("\n");
    sb.append("    deadBandValue: ").append(toIndentedString(deadBandValue)).append("\n");
    sb.append("    valueChange: ").append(toIndentedString(valueChange)).append("\n");
    sb.append("    browselistChange: ").append(toIndentedString(browselistChange)).append("\n");
    sb.append("    metadataChange: ").append(toIndentedString(metadataChange)).append("\n");
    sb.append("    countSubscriptions: ").append(toIndentedString(countSubscriptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `samplingInterval` to the URL query string
    if (getSamplingInterval() != null) {
      try {
        joiner.add(String.format("%ssamplingInterval%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSamplingInterval()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `queueSize` to the URL query string
    if (getQueueSize() != null) {
      try {
        joiner.add(String.format("%squeueSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getQueueSize()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `behaviour` to the URL query string
    if (getBehaviour() != null) {
      try {
        joiner.add(String.format("%sbehaviour%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBehaviour()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deadBandValue` to the URL query string
    if (getDeadBandValue() != null) {
      try {
        joiner.add(String.format("%sdeadBandValue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeadBandValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `valueChange` to the URL query string
    if (getValueChange() != null) {
      try {
        joiner.add(String.format("%svalueChange%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getValueChange()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `browselistChange` to the URL query string
    if (getBrowselistChange() != null) {
      try {
        joiner.add(String.format("%sbrowselistChange%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBrowselistChange()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `metadataChange` to the URL query string
    if (getMetadataChange() != null) {
      try {
        joiner.add(String.format("%smetadataChange%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMetadataChange()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `countSubscriptions` to the URL query string
    if (getCountSubscriptions() != null) {
      try {
        joiner.add(String.format("%scountSubscriptions%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCountSubscriptions()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

