/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtPropertyValueRead is the corresponding interface of ApduDataExtPropertyValueRead
type ApduDataExtPropertyValueRead interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// GetObjectIndex returns ObjectIndex (property field)
	GetObjectIndex() uint8
	// GetPropertyId returns PropertyId (property field)
	GetPropertyId() uint8
	// GetCount returns Count (property field)
	GetCount() uint8
	// GetIndex returns Index (property field)
	GetIndex() uint16
	// IsApduDataExtPropertyValueRead is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtPropertyValueRead()
	// CreateBuilder creates a ApduDataExtPropertyValueReadBuilder
	CreateApduDataExtPropertyValueReadBuilder() ApduDataExtPropertyValueReadBuilder
}

// _ApduDataExtPropertyValueRead is the data-structure of this message
type _ApduDataExtPropertyValueRead struct {
	ApduDataExtContract
	ObjectIndex uint8
	PropertyId  uint8
	Count       uint8
	Index       uint16
}

var _ ApduDataExtPropertyValueRead = (*_ApduDataExtPropertyValueRead)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtPropertyValueRead)(nil)

// NewApduDataExtPropertyValueRead factory function for _ApduDataExtPropertyValueRead
func NewApduDataExtPropertyValueRead(objectIndex uint8, propertyId uint8, count uint8, index uint16, length uint8) *_ApduDataExtPropertyValueRead {
	_result := &_ApduDataExtPropertyValueRead{
		ApduDataExtContract: NewApduDataExt(length),
		ObjectIndex:         objectIndex,
		PropertyId:          propertyId,
		Count:               count,
		Index:               index,
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtPropertyValueReadBuilder is a builder for ApduDataExtPropertyValueRead
type ApduDataExtPropertyValueReadBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectIndex uint8, propertyId uint8, count uint8, index uint16) ApduDataExtPropertyValueReadBuilder
	// WithObjectIndex adds ObjectIndex (property field)
	WithObjectIndex(uint8) ApduDataExtPropertyValueReadBuilder
	// WithPropertyId adds PropertyId (property field)
	WithPropertyId(uint8) ApduDataExtPropertyValueReadBuilder
	// WithCount adds Count (property field)
	WithCount(uint8) ApduDataExtPropertyValueReadBuilder
	// WithIndex adds Index (property field)
	WithIndex(uint16) ApduDataExtPropertyValueReadBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtPropertyValueRead or returns an error if something is wrong
	Build() (ApduDataExtPropertyValueRead, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtPropertyValueRead
}

// NewApduDataExtPropertyValueReadBuilder() creates a ApduDataExtPropertyValueReadBuilder
func NewApduDataExtPropertyValueReadBuilder() ApduDataExtPropertyValueReadBuilder {
	return &_ApduDataExtPropertyValueReadBuilder{_ApduDataExtPropertyValueRead: new(_ApduDataExtPropertyValueRead)}
}

type _ApduDataExtPropertyValueReadBuilder struct {
	*_ApduDataExtPropertyValueRead

	parentBuilder *_ApduDataExtBuilder

	collectedErr []error
}

var _ (ApduDataExtPropertyValueReadBuilder) = (*_ApduDataExtPropertyValueReadBuilder)(nil)

func (b *_ApduDataExtPropertyValueReadBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtPropertyValueRead
}

func (b *_ApduDataExtPropertyValueReadBuilder) WithMandatoryFields(objectIndex uint8, propertyId uint8, count uint8, index uint16) ApduDataExtPropertyValueReadBuilder {
	return b.WithObjectIndex(objectIndex).WithPropertyId(propertyId).WithCount(count).WithIndex(index)
}

func (b *_ApduDataExtPropertyValueReadBuilder) WithObjectIndex(objectIndex uint8) ApduDataExtPropertyValueReadBuilder {
	b.ObjectIndex = objectIndex
	return b
}

func (b *_ApduDataExtPropertyValueReadBuilder) WithPropertyId(propertyId uint8) ApduDataExtPropertyValueReadBuilder {
	b.PropertyId = propertyId
	return b
}

func (b *_ApduDataExtPropertyValueReadBuilder) WithCount(count uint8) ApduDataExtPropertyValueReadBuilder {
	b.Count = count
	return b
}

func (b *_ApduDataExtPropertyValueReadBuilder) WithIndex(index uint16) ApduDataExtPropertyValueReadBuilder {
	b.Index = index
	return b
}

func (b *_ApduDataExtPropertyValueReadBuilder) Build() (ApduDataExtPropertyValueRead, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApduDataExtPropertyValueRead.deepCopy(), nil
}

func (b *_ApduDataExtPropertyValueReadBuilder) MustBuild() ApduDataExtPropertyValueRead {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtPropertyValueReadBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtPropertyValueReadBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtPropertyValueReadBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtPropertyValueReadBuilder().(*_ApduDataExtPropertyValueReadBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApduDataExtPropertyValueReadBuilder creates a ApduDataExtPropertyValueReadBuilder
func (b *_ApduDataExtPropertyValueRead) CreateApduDataExtPropertyValueReadBuilder() ApduDataExtPropertyValueReadBuilder {
	if b == nil {
		return NewApduDataExtPropertyValueReadBuilder()
	}
	return &_ApduDataExtPropertyValueReadBuilder{_ApduDataExtPropertyValueRead: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtPropertyValueRead) GetExtApciType() uint8 {
	return 0x15
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtPropertyValueRead) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ApduDataExtPropertyValueRead) GetObjectIndex() uint8 {
	return m.ObjectIndex
}

func (m *_ApduDataExtPropertyValueRead) GetPropertyId() uint8 {
	return m.PropertyId
}

func (m *_ApduDataExtPropertyValueRead) GetCount() uint8 {
	return m.Count
}

func (m *_ApduDataExtPropertyValueRead) GetIndex() uint16 {
	return m.Index
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastApduDataExtPropertyValueRead(structType any) ApduDataExtPropertyValueRead {
	if casted, ok := structType.(ApduDataExtPropertyValueRead); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtPropertyValueRead); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtPropertyValueRead) GetTypeName() string {
	return "ApduDataExtPropertyValueRead"
}

func (m *_ApduDataExtPropertyValueRead) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	// Simple field (objectIndex)
	lengthInBits += 8

	// Simple field (propertyId)
	lengthInBits += 8

	// Simple field (count)
	lengthInBits += 4

	// Simple field (index)
	lengthInBits += 12

	return lengthInBits
}

func (m *_ApduDataExtPropertyValueRead) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtPropertyValueRead) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtPropertyValueRead ApduDataExtPropertyValueRead, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtPropertyValueRead"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtPropertyValueRead")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectIndex, err := ReadSimpleField(ctx, "objectIndex", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIndex' field"))
	}
	m.ObjectIndex = objectIndex

	propertyId, err := ReadSimpleField(ctx, "propertyId", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'propertyId' field"))
	}
	m.PropertyId = propertyId

	count, err := ReadSimpleField(ctx, "count", ReadUnsignedByte(readBuffer, uint8(4)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'count' field"))
	}
	m.Count = count

	index, err := ReadSimpleField(ctx, "index", ReadUnsignedShort(readBuffer, uint8(12)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'index' field"))
	}
	m.Index = index

	if closeErr := readBuffer.CloseContext("ApduDataExtPropertyValueRead"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtPropertyValueRead")
	}

	return m, nil
}

func (m *_ApduDataExtPropertyValueRead) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtPropertyValueRead) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtPropertyValueRead"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtPropertyValueRead")
		}

		if err := WriteSimpleField[uint8](ctx, "objectIndex", m.GetObjectIndex(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'objectIndex' field")
		}

		if err := WriteSimpleField[uint8](ctx, "propertyId", m.GetPropertyId(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'propertyId' field")
		}

		if err := WriteSimpleField[uint8](ctx, "count", m.GetCount(), WriteUnsignedByte(writeBuffer, 4)); err != nil {
			return errors.Wrap(err, "Error serializing 'count' field")
		}

		if err := WriteSimpleField[uint16](ctx, "index", m.GetIndex(), WriteUnsignedShort(writeBuffer, 12)); err != nil {
			return errors.Wrap(err, "Error serializing 'index' field")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtPropertyValueRead"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtPropertyValueRead")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtPropertyValueRead) IsApduDataExtPropertyValueRead() {}

func (m *_ApduDataExtPropertyValueRead) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtPropertyValueRead) deepCopy() *_ApduDataExtPropertyValueRead {
	if m == nil {
		return nil
	}
	_ApduDataExtPropertyValueReadCopy := &_ApduDataExtPropertyValueRead{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
		m.ObjectIndex,
		m.PropertyId,
		m.Count,
		m.Index,
	}
	_ApduDataExtPropertyValueReadCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtPropertyValueReadCopy
}

func (m *_ApduDataExtPropertyValueRead) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
