/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtGroupPropertyValueInfoReport is the corresponding interface of ApduDataExtGroupPropertyValueInfoReport
type ApduDataExtGroupPropertyValueInfoReport interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtGroupPropertyValueInfoReport is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtGroupPropertyValueInfoReport()
	// CreateBuilder creates a ApduDataExtGroupPropertyValueInfoReportBuilder
	CreateApduDataExtGroupPropertyValueInfoReportBuilder() ApduDataExtGroupPropertyValueInfoReportBuilder
}

// _ApduDataExtGroupPropertyValueInfoReport is the data-structure of this message
type _ApduDataExtGroupPropertyValueInfoReport struct {
	ApduDataExtContract
}

var _ ApduDataExtGroupPropertyValueInfoReport = (*_ApduDataExtGroupPropertyValueInfoReport)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtGroupPropertyValueInfoReport)(nil)

// NewApduDataExtGroupPropertyValueInfoReport factory function for _ApduDataExtGroupPropertyValueInfoReport
func NewApduDataExtGroupPropertyValueInfoReport(length uint8) *_ApduDataExtGroupPropertyValueInfoReport {
	_result := &_ApduDataExtGroupPropertyValueInfoReport{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtGroupPropertyValueInfoReportBuilder is a builder for ApduDataExtGroupPropertyValueInfoReport
type ApduDataExtGroupPropertyValueInfoReportBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtGroupPropertyValueInfoReportBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtGroupPropertyValueInfoReport or returns an error if something is wrong
	Build() (ApduDataExtGroupPropertyValueInfoReport, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtGroupPropertyValueInfoReport
}

// NewApduDataExtGroupPropertyValueInfoReportBuilder() creates a ApduDataExtGroupPropertyValueInfoReportBuilder
func NewApduDataExtGroupPropertyValueInfoReportBuilder() ApduDataExtGroupPropertyValueInfoReportBuilder {
	return &_ApduDataExtGroupPropertyValueInfoReportBuilder{_ApduDataExtGroupPropertyValueInfoReport: new(_ApduDataExtGroupPropertyValueInfoReport)}
}

type _ApduDataExtGroupPropertyValueInfoReportBuilder struct {
	*_ApduDataExtGroupPropertyValueInfoReport

	parentBuilder *_ApduDataExtBuilder

	collectedErr []error
}

var _ (ApduDataExtGroupPropertyValueInfoReportBuilder) = (*_ApduDataExtGroupPropertyValueInfoReportBuilder)(nil)

func (b *_ApduDataExtGroupPropertyValueInfoReportBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtGroupPropertyValueInfoReport
}

func (b *_ApduDataExtGroupPropertyValueInfoReportBuilder) WithMandatoryFields() ApduDataExtGroupPropertyValueInfoReportBuilder {
	return b
}

func (b *_ApduDataExtGroupPropertyValueInfoReportBuilder) Build() (ApduDataExtGroupPropertyValueInfoReport, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApduDataExtGroupPropertyValueInfoReport.deepCopy(), nil
}

func (b *_ApduDataExtGroupPropertyValueInfoReportBuilder) MustBuild() ApduDataExtGroupPropertyValueInfoReport {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtGroupPropertyValueInfoReportBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtGroupPropertyValueInfoReportBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtGroupPropertyValueInfoReportBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtGroupPropertyValueInfoReportBuilder().(*_ApduDataExtGroupPropertyValueInfoReportBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApduDataExtGroupPropertyValueInfoReportBuilder creates a ApduDataExtGroupPropertyValueInfoReportBuilder
func (b *_ApduDataExtGroupPropertyValueInfoReport) CreateApduDataExtGroupPropertyValueInfoReportBuilder() ApduDataExtGroupPropertyValueInfoReportBuilder {
	if b == nil {
		return NewApduDataExtGroupPropertyValueInfoReportBuilder()
	}
	return &_ApduDataExtGroupPropertyValueInfoReportBuilder{_ApduDataExtGroupPropertyValueInfoReport: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtGroupPropertyValueInfoReport) GetExtApciType() uint8 {
	return 0x2B
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtGroupPropertyValueInfoReport) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtGroupPropertyValueInfoReport(structType any) ApduDataExtGroupPropertyValueInfoReport {
	if casted, ok := structType.(ApduDataExtGroupPropertyValueInfoReport); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtGroupPropertyValueInfoReport); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtGroupPropertyValueInfoReport) GetTypeName() string {
	return "ApduDataExtGroupPropertyValueInfoReport"
}

func (m *_ApduDataExtGroupPropertyValueInfoReport) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtGroupPropertyValueInfoReport) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtGroupPropertyValueInfoReport) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtGroupPropertyValueInfoReport ApduDataExtGroupPropertyValueInfoReport, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtGroupPropertyValueInfoReport"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtGroupPropertyValueInfoReport")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtGroupPropertyValueInfoReport"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtGroupPropertyValueInfoReport")
	}

	return m, nil
}

func (m *_ApduDataExtGroupPropertyValueInfoReport) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtGroupPropertyValueInfoReport) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtGroupPropertyValueInfoReport"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtGroupPropertyValueInfoReport")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtGroupPropertyValueInfoReport"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtGroupPropertyValueInfoReport")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtGroupPropertyValueInfoReport) IsApduDataExtGroupPropertyValueInfoReport() {}

func (m *_ApduDataExtGroupPropertyValueInfoReport) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtGroupPropertyValueInfoReport) deepCopy() *_ApduDataExtGroupPropertyValueInfoReport {
	if m == nil {
		return nil
	}
	_ApduDataExtGroupPropertyValueInfoReportCopy := &_ApduDataExtGroupPropertyValueInfoReport{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtGroupPropertyValueInfoReportCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtGroupPropertyValueInfoReportCopy
}

func (m *_ApduDataExtGroupPropertyValueInfoReport) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
