/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TelephonyDataClearDiversion is the corresponding interface of TelephonyDataClearDiversion
type TelephonyDataClearDiversion interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	TelephonyData
	// IsTelephonyDataClearDiversion is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTelephonyDataClearDiversion()
	// CreateBuilder creates a TelephonyDataClearDiversionBuilder
	CreateTelephonyDataClearDiversionBuilder() TelephonyDataClearDiversionBuilder
}

// _TelephonyDataClearDiversion is the data-structure of this message
type _TelephonyDataClearDiversion struct {
	TelephonyDataContract
}

var _ TelephonyDataClearDiversion = (*_TelephonyDataClearDiversion)(nil)
var _ TelephonyDataRequirements = (*_TelephonyDataClearDiversion)(nil)

// NewTelephonyDataClearDiversion factory function for _TelephonyDataClearDiversion
func NewTelephonyDataClearDiversion(commandTypeContainer TelephonyCommandTypeContainer, argument byte) *_TelephonyDataClearDiversion {
	_result := &_TelephonyDataClearDiversion{
		TelephonyDataContract: NewTelephonyData(commandTypeContainer, argument),
	}
	_result.TelephonyDataContract.(*_TelephonyData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TelephonyDataClearDiversionBuilder is a builder for TelephonyDataClearDiversion
type TelephonyDataClearDiversionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() TelephonyDataClearDiversionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() TelephonyDataBuilder
	// Build builds the TelephonyDataClearDiversion or returns an error if something is wrong
	Build() (TelephonyDataClearDiversion, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TelephonyDataClearDiversion
}

// NewTelephonyDataClearDiversionBuilder() creates a TelephonyDataClearDiversionBuilder
func NewTelephonyDataClearDiversionBuilder() TelephonyDataClearDiversionBuilder {
	return &_TelephonyDataClearDiversionBuilder{_TelephonyDataClearDiversion: new(_TelephonyDataClearDiversion)}
}

type _TelephonyDataClearDiversionBuilder struct {
	*_TelephonyDataClearDiversion

	parentBuilder *_TelephonyDataBuilder

	collectedErr []error
}

var _ (TelephonyDataClearDiversionBuilder) = (*_TelephonyDataClearDiversionBuilder)(nil)

func (b *_TelephonyDataClearDiversionBuilder) setParent(contract TelephonyDataContract) {
	b.TelephonyDataContract = contract
	contract.(*_TelephonyData)._SubType = b._TelephonyDataClearDiversion
}

func (b *_TelephonyDataClearDiversionBuilder) WithMandatoryFields() TelephonyDataClearDiversionBuilder {
	return b
}

func (b *_TelephonyDataClearDiversionBuilder) Build() (TelephonyDataClearDiversion, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._TelephonyDataClearDiversion.deepCopy(), nil
}

func (b *_TelephonyDataClearDiversionBuilder) MustBuild() TelephonyDataClearDiversion {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TelephonyDataClearDiversionBuilder) Done() TelephonyDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewTelephonyDataBuilder().(*_TelephonyDataBuilder)
	}
	return b.parentBuilder
}

func (b *_TelephonyDataClearDiversionBuilder) buildForTelephonyData() (TelephonyData, error) {
	return b.Build()
}

func (b *_TelephonyDataClearDiversionBuilder) DeepCopy() any {
	_copy := b.CreateTelephonyDataClearDiversionBuilder().(*_TelephonyDataClearDiversionBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateTelephonyDataClearDiversionBuilder creates a TelephonyDataClearDiversionBuilder
func (b *_TelephonyDataClearDiversion) CreateTelephonyDataClearDiversionBuilder() TelephonyDataClearDiversionBuilder {
	if b == nil {
		return NewTelephonyDataClearDiversionBuilder()
	}
	return &_TelephonyDataClearDiversionBuilder{_TelephonyDataClearDiversion: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TelephonyDataClearDiversion) GetParent() TelephonyDataContract {
	return m.TelephonyDataContract
}

// Deprecated: use the interface for direct cast
func CastTelephonyDataClearDiversion(structType any) TelephonyDataClearDiversion {
	if casted, ok := structType.(TelephonyDataClearDiversion); ok {
		return casted
	}
	if casted, ok := structType.(*TelephonyDataClearDiversion); ok {
		return *casted
	}
	return nil
}

func (m *_TelephonyDataClearDiversion) GetTypeName() string {
	return "TelephonyDataClearDiversion"
}

func (m *_TelephonyDataClearDiversion) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.TelephonyDataContract.(*_TelephonyData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_TelephonyDataClearDiversion) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_TelephonyDataClearDiversion) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_TelephonyData) (__telephonyDataClearDiversion TelephonyDataClearDiversion, err error) {
	m.TelephonyDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TelephonyDataClearDiversion"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TelephonyDataClearDiversion")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("TelephonyDataClearDiversion"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TelephonyDataClearDiversion")
	}

	return m, nil
}

func (m *_TelephonyDataClearDiversion) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TelephonyDataClearDiversion) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TelephonyDataClearDiversion"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TelephonyDataClearDiversion")
		}

		if popErr := writeBuffer.PopContext("TelephonyDataClearDiversion"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TelephonyDataClearDiversion")
		}
		return nil
	}
	return m.TelephonyDataContract.(*_TelephonyData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TelephonyDataClearDiversion) IsTelephonyDataClearDiversion() {}

func (m *_TelephonyDataClearDiversion) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TelephonyDataClearDiversion) deepCopy() *_TelephonyDataClearDiversion {
	if m == nil {
		return nil
	}
	_TelephonyDataClearDiversionCopy := &_TelephonyDataClearDiversion{
		m.TelephonyDataContract.(*_TelephonyData).deepCopy(),
	}
	_TelephonyDataClearDiversionCopy.TelephonyDataContract.(*_TelephonyData)._SubType = m
	return _TelephonyDataClearDiversionCopy
}

func (m *_TelephonyDataClearDiversion) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
