/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetGroupChannelValue is the corresponding interface of BACnetGroupChannelValue
type BACnetGroupChannelValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetChannel returns Channel (property field)
	GetChannel() BACnetContextTagUnsignedInteger
	// GetOverridingPriority returns OverridingPriority (property field)
	GetOverridingPriority() BACnetContextTagUnsignedInteger
	// GetValue returns Value (property field)
	GetValue() BACnetChannelValue
	// IsBACnetGroupChannelValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetGroupChannelValue()
	// CreateBuilder creates a BACnetGroupChannelValueBuilder
	CreateBACnetGroupChannelValueBuilder() BACnetGroupChannelValueBuilder
}

// _BACnetGroupChannelValue is the data-structure of this message
type _BACnetGroupChannelValue struct {
	Channel            BACnetContextTagUnsignedInteger
	OverridingPriority BACnetContextTagUnsignedInteger
	Value              BACnetChannelValue
}

var _ BACnetGroupChannelValue = (*_BACnetGroupChannelValue)(nil)

// NewBACnetGroupChannelValue factory function for _BACnetGroupChannelValue
func NewBACnetGroupChannelValue(channel BACnetContextTagUnsignedInteger, overridingPriority BACnetContextTagUnsignedInteger, value BACnetChannelValue) *_BACnetGroupChannelValue {
	if channel == nil {
		panic("channel of type BACnetContextTagUnsignedInteger for BACnetGroupChannelValue must not be nil")
	}
	if value == nil {
		panic("value of type BACnetChannelValue for BACnetGroupChannelValue must not be nil")
	}
	return &_BACnetGroupChannelValue{Channel: channel, OverridingPriority: overridingPriority, Value: value}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetGroupChannelValueBuilder is a builder for BACnetGroupChannelValue
type BACnetGroupChannelValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(channel BACnetContextTagUnsignedInteger, value BACnetChannelValue) BACnetGroupChannelValueBuilder
	// WithChannel adds Channel (property field)
	WithChannel(BACnetContextTagUnsignedInteger) BACnetGroupChannelValueBuilder
	// WithChannelBuilder adds Channel (property field) which is build by the builder
	WithChannelBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetGroupChannelValueBuilder
	// WithOverridingPriority adds OverridingPriority (property field)
	WithOptionalOverridingPriority(BACnetContextTagUnsignedInteger) BACnetGroupChannelValueBuilder
	// WithOptionalOverridingPriorityBuilder adds OverridingPriority (property field) which is build by the builder
	WithOptionalOverridingPriorityBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetGroupChannelValueBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetChannelValue) BACnetGroupChannelValueBuilder
	// WithValueBuilder adds Value (property field) which is build by the builder
	WithValueBuilder(func(BACnetChannelValueBuilder) BACnetChannelValueBuilder) BACnetGroupChannelValueBuilder
	// Build builds the BACnetGroupChannelValue or returns an error if something is wrong
	Build() (BACnetGroupChannelValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetGroupChannelValue
}

// NewBACnetGroupChannelValueBuilder() creates a BACnetGroupChannelValueBuilder
func NewBACnetGroupChannelValueBuilder() BACnetGroupChannelValueBuilder {
	return &_BACnetGroupChannelValueBuilder{_BACnetGroupChannelValue: new(_BACnetGroupChannelValue)}
}

type _BACnetGroupChannelValueBuilder struct {
	*_BACnetGroupChannelValue

	collectedErr []error
}

var _ (BACnetGroupChannelValueBuilder) = (*_BACnetGroupChannelValueBuilder)(nil)

func (b *_BACnetGroupChannelValueBuilder) WithMandatoryFields(channel BACnetContextTagUnsignedInteger, value BACnetChannelValue) BACnetGroupChannelValueBuilder {
	return b.WithChannel(channel).WithValue(value)
}

func (b *_BACnetGroupChannelValueBuilder) WithChannel(channel BACnetContextTagUnsignedInteger) BACnetGroupChannelValueBuilder {
	b.Channel = channel
	return b
}

func (b *_BACnetGroupChannelValueBuilder) WithChannelBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetGroupChannelValueBuilder {
	builder := builderSupplier(b.Channel.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.Channel, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetGroupChannelValueBuilder) WithOptionalOverridingPriority(overridingPriority BACnetContextTagUnsignedInteger) BACnetGroupChannelValueBuilder {
	b.OverridingPriority = overridingPriority
	return b
}

func (b *_BACnetGroupChannelValueBuilder) WithOptionalOverridingPriorityBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetGroupChannelValueBuilder {
	builder := builderSupplier(b.OverridingPriority.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.OverridingPriority, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetGroupChannelValueBuilder) WithValue(value BACnetChannelValue) BACnetGroupChannelValueBuilder {
	b.Value = value
	return b
}

func (b *_BACnetGroupChannelValueBuilder) WithValueBuilder(builderSupplier func(BACnetChannelValueBuilder) BACnetChannelValueBuilder) BACnetGroupChannelValueBuilder {
	builder := builderSupplier(b.Value.CreateBACnetChannelValueBuilder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetChannelValueBuilder failed"))
	}
	return b
}

func (b *_BACnetGroupChannelValueBuilder) Build() (BACnetGroupChannelValue, error) {
	if b.Channel == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'channel' not set"))
	}
	if b.Value == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'value' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetGroupChannelValue.deepCopy(), nil
}

func (b *_BACnetGroupChannelValueBuilder) MustBuild() BACnetGroupChannelValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetGroupChannelValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetGroupChannelValueBuilder().(*_BACnetGroupChannelValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetGroupChannelValueBuilder creates a BACnetGroupChannelValueBuilder
func (b *_BACnetGroupChannelValue) CreateBACnetGroupChannelValueBuilder() BACnetGroupChannelValueBuilder {
	if b == nil {
		return NewBACnetGroupChannelValueBuilder()
	}
	return &_BACnetGroupChannelValueBuilder{_BACnetGroupChannelValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetGroupChannelValue) GetChannel() BACnetContextTagUnsignedInteger {
	return m.Channel
}

func (m *_BACnetGroupChannelValue) GetOverridingPriority() BACnetContextTagUnsignedInteger {
	return m.OverridingPriority
}

func (m *_BACnetGroupChannelValue) GetValue() BACnetChannelValue {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetGroupChannelValue(structType any) BACnetGroupChannelValue {
	if casted, ok := structType.(BACnetGroupChannelValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetGroupChannelValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetGroupChannelValue) GetTypeName() string {
	return "BACnetGroupChannelValue"
}

func (m *_BACnetGroupChannelValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (channel)
	lengthInBits += m.Channel.GetLengthInBits(ctx)

	// Optional Field (overridingPriority)
	if m.OverridingPriority != nil {
		lengthInBits += m.OverridingPriority.GetLengthInBits(ctx)
	}

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetGroupChannelValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetGroupChannelValueParse(ctx context.Context, theBytes []byte) (BACnetGroupChannelValue, error) {
	return BACnetGroupChannelValueParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetGroupChannelValueParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetGroupChannelValue, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetGroupChannelValue, error) {
		return BACnetGroupChannelValueParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetGroupChannelValueParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetGroupChannelValue, error) {
	v, err := (&_BACnetGroupChannelValue{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetGroupChannelValue) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetGroupChannelValue BACnetGroupChannelValue, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetGroupChannelValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetGroupChannelValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	channel, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "channel", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'channel' field"))
	}
	m.Channel = channel

	var overridingPriority BACnetContextTagUnsignedInteger
	_overridingPriority, err := ReadOptionalField[BACnetContextTagUnsignedInteger](ctx, "overridingPriority", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(1)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'overridingPriority' field"))
	}
	if _overridingPriority != nil {
		overridingPriority = *_overridingPriority
		m.OverridingPriority = overridingPriority
	}

	value, err := ReadSimpleField[BACnetChannelValue](ctx, "value", ReadComplex[BACnetChannelValue](BACnetChannelValueParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetGroupChannelValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetGroupChannelValue")
	}

	return m, nil
}

func (m *_BACnetGroupChannelValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetGroupChannelValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetGroupChannelValue"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetGroupChannelValue")
	}

	if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "channel", m.GetChannel(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'channel' field")
	}

	if err := WriteOptionalField[BACnetContextTagUnsignedInteger](ctx, "overridingPriority", GetRef(m.GetOverridingPriority()), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'overridingPriority' field")
	}

	if err := WriteSimpleField[BACnetChannelValue](ctx, "value", m.GetValue(), WriteComplex[BACnetChannelValue](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetGroupChannelValue"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetGroupChannelValue")
	}
	return nil
}

func (m *_BACnetGroupChannelValue) IsBACnetGroupChannelValue() {}

func (m *_BACnetGroupChannelValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetGroupChannelValue) deepCopy() *_BACnetGroupChannelValue {
	if m == nil {
		return nil
	}
	_BACnetGroupChannelValueCopy := &_BACnetGroupChannelValue{
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.Channel),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.OverridingPriority),
		utils.DeepCopy[BACnetChannelValue](m.Value),
	}
	return _BACnetGroupChannelValueCopy
}

func (m *_BACnetGroupChannelValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
