/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLifeSafetyZoneFaultValues is the corresponding interface of BACnetConstructedDataLifeSafetyZoneFaultValues
type BACnetConstructedDataLifeSafetyZoneFaultValues interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetFaultValues returns FaultValues (property field)
	GetFaultValues() []BACnetLifeSafetyStateTagged
	// IsBACnetConstructedDataLifeSafetyZoneFaultValues is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLifeSafetyZoneFaultValues()
	// CreateBuilder creates a BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder
	CreateBACnetConstructedDataLifeSafetyZoneFaultValuesBuilder() BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder
}

// _BACnetConstructedDataLifeSafetyZoneFaultValues is the data-structure of this message
type _BACnetConstructedDataLifeSafetyZoneFaultValues struct {
	BACnetConstructedDataContract
	FaultValues []BACnetLifeSafetyStateTagged
}

var _ BACnetConstructedDataLifeSafetyZoneFaultValues = (*_BACnetConstructedDataLifeSafetyZoneFaultValues)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLifeSafetyZoneFaultValues)(nil)

// NewBACnetConstructedDataLifeSafetyZoneFaultValues factory function for _BACnetConstructedDataLifeSafetyZoneFaultValues
func NewBACnetConstructedDataLifeSafetyZoneFaultValues(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, faultValues []BACnetLifeSafetyStateTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLifeSafetyZoneFaultValues {
	_result := &_BACnetConstructedDataLifeSafetyZoneFaultValues{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		FaultValues:                   faultValues,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder is a builder for BACnetConstructedDataLifeSafetyZoneFaultValues
type BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(faultValues []BACnetLifeSafetyStateTagged) BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder
	// WithFaultValues adds FaultValues (property field)
	WithFaultValues(...BACnetLifeSafetyStateTagged) BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLifeSafetyZoneFaultValues or returns an error if something is wrong
	Build() (BACnetConstructedDataLifeSafetyZoneFaultValues, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLifeSafetyZoneFaultValues
}

// NewBACnetConstructedDataLifeSafetyZoneFaultValuesBuilder() creates a BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder
func NewBACnetConstructedDataLifeSafetyZoneFaultValuesBuilder() BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder {
	return &_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder{_BACnetConstructedDataLifeSafetyZoneFaultValues: new(_BACnetConstructedDataLifeSafetyZoneFaultValues)}
}

type _BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder struct {
	*_BACnetConstructedDataLifeSafetyZoneFaultValues

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder) = (*_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder)(nil)

func (b *_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLifeSafetyZoneFaultValues
}

func (b *_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder) WithMandatoryFields(faultValues []BACnetLifeSafetyStateTagged) BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder {
	return b.WithFaultValues(faultValues...)
}

func (b *_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder) WithFaultValues(faultValues ...BACnetLifeSafetyStateTagged) BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder {
	b.FaultValues = faultValues
	return b
}

func (b *_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder) Build() (BACnetConstructedDataLifeSafetyZoneFaultValues, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataLifeSafetyZoneFaultValues.deepCopy(), nil
}

func (b *_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder) MustBuild() BACnetConstructedDataLifeSafetyZoneFaultValues {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLifeSafetyZoneFaultValuesBuilder().(*_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataLifeSafetyZoneFaultValuesBuilder creates a BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder
func (b *_BACnetConstructedDataLifeSafetyZoneFaultValues) CreateBACnetConstructedDataLifeSafetyZoneFaultValuesBuilder() BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder {
	if b == nil {
		return NewBACnetConstructedDataLifeSafetyZoneFaultValuesBuilder()
	}
	return &_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder{_BACnetConstructedDataLifeSafetyZoneFaultValues: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_LIFE_SAFETY_ZONE
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_FAULT_VALUES
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) GetFaultValues() []BACnetLifeSafetyStateTagged {
	return m.FaultValues
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLifeSafetyZoneFaultValues(structType any) BACnetConstructedDataLifeSafetyZoneFaultValues {
	if casted, ok := structType.(BACnetConstructedDataLifeSafetyZoneFaultValues); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLifeSafetyZoneFaultValues); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) GetTypeName() string {
	return "BACnetConstructedDataLifeSafetyZoneFaultValues"
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.FaultValues) > 0 {
		for _, element := range m.FaultValues {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLifeSafetyZoneFaultValues BACnetConstructedDataLifeSafetyZoneFaultValues, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLifeSafetyZoneFaultValues"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLifeSafetyZoneFaultValues")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	faultValues, err := ReadTerminatedArrayField[BACnetLifeSafetyStateTagged](ctx, "faultValues", ReadComplex[BACnetLifeSafetyStateTagged](BACnetLifeSafetyStateTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'faultValues' field"))
	}
	m.FaultValues = faultValues

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLifeSafetyZoneFaultValues"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLifeSafetyZoneFaultValues")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLifeSafetyZoneFaultValues"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLifeSafetyZoneFaultValues")
		}

		if err := WriteComplexTypeArrayField(ctx, "faultValues", m.GetFaultValues(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'faultValues' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLifeSafetyZoneFaultValues"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLifeSafetyZoneFaultValues")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) IsBACnetConstructedDataLifeSafetyZoneFaultValues() {
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) deepCopy() *_BACnetConstructedDataLifeSafetyZoneFaultValues {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLifeSafetyZoneFaultValuesCopy := &_BACnetConstructedDataLifeSafetyZoneFaultValues{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetLifeSafetyStateTagged, BACnetLifeSafetyStateTagged](m.FaultValues),
	}
	_BACnetConstructedDataLifeSafetyZoneFaultValuesCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLifeSafetyZoneFaultValuesCopy
}

func (m *_BACnetConstructedDataLifeSafetyZoneFaultValues) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
