/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef __LPS33HW_PRIV_H__
#define __LPS33HW_PRIV_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Max time to wait for interrupt */
#define LPS33HW_MAX_INT_WAIT (4 * OS_TICKS_PER_SEC)

enum lps33hw_registers {
    LPS33HW_INTERRUPT_CFG = 0x0b,
    LPS33HW_THS_P = 0x0c,
    LPS33HW_IF_CTRL = 0x0e,
    LPS33HW_WHO_AM_I = 0x0f,
    LPS33HW_CTRL_REG1 = 0x10,
    LPS33HW_CTRL_REG2 = 0x11,
    LPS33HW_CTRL_REG3 = 0x12,
    LPS33HW_FIFO_CTRL = 0x14,
    LPS33HW_REF_P = 0x15,
    LPS33HW_RPDS = 0x18,
    LPS33HW_RES_CONF = 0x1a,
    LPS33HW_INT_SOURCE = 0x25,
    LPS33HW_FIFO_STATUS = 0x26,
    LPS33HW_STATUS = 0x27,
    LPS33HW_PRESS_OUT = 0x28,
    LPS33HW_TEMP_OUT = 0x2b,
    LPS33HW_LPFP_RES = 0x33
};

enum lps33hw_fifo_mode {
    LPS33HW_FIFO_BYPASS = 0x00,
    LPS33HW_FIFO_CONTINUOUS = 0x02,
};

/* registers */
struct lps33hw_register_value {
    uint8_t reg;
    uint8_t pos;
    uint8_t mask;
};

#define LPS33HW_INT_LOW_BIT (0x01)
#define LPS33HW_INT_HIGH_BIT (0x01)

#define LPS33HW_REGISTER_VALUE(r, n, p, m) \
static const struct lps33hw_register_value n = {.reg = r, .pos = p, .mask = m}

LPS33HW_REGISTER_VALUE(LPS33HW_INTERRUPT_CFG, LPS33HW_INTERRUPT_CFG_AUTORIFP, 7, 0x80);
LPS33HW_REGISTER_VALUE(LPS33HW_INTERRUPT_CFG, LPS33HW_INTERRUPT_CFG_RESET_ARP, 6, 0x40);
LPS33HW_REGISTER_VALUE(LPS33HW_INTERRUPT_CFG, LPS33HW_INTERRUPT_CFG_AUTOZERO, 5, 0x20);
LPS33HW_REGISTER_VALUE(LPS33HW_INTERRUPT_CFG, LPS33HW_INTERRUPT_CFG_RESET_AZ, 4, 0x10);
LPS33HW_REGISTER_VALUE(LPS33HW_INTERRUPT_CFG, LPS33HW_INTERRUPT_CFG_DIFF_EN, 3, 0x08);
LPS33HW_REGISTER_VALUE(LPS33HW_INTERRUPT_CFG, LPS33HW_INTERRUPT_CFG_LIR, 2, 0x04);
LPS33HW_REGISTER_VALUE(LPS33HW_INTERRUPT_CFG, LPS33HW_INTERRUPT_CFG_PLE, 1, 0x02);
LPS33HW_REGISTER_VALUE(LPS33HW_INTERRUPT_CFG, LPS33HW_INTERRUPT_CFG_PHE, 0, 0x01);

LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG1, LPS33HW_CTRL_REG1_ODR, 4, 0x70);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG1, LPS33HW_CTRL_REG1_EN_LPFP, 3, 0x08);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG1, LPS33HW_CTRL_REG1_LPFP_CFG, 2, 0x04);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG1, LPS33HW_CTRL_REG1_BDU, 1, 0x02);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG1, LPS33HW_CTRL_REG1_SIM, 0, 0x01);

LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG2, LPS33HW_CTRL_REG2_BOOT, 7, 0x80);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG2, LPS33HW_CTRL_REG2_FIFO_EN, 6, 0x40);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG2, LPS33HW_CTRL_REG2_STOP_ON_FTH, 5, 0x20);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG2, LPS33HW_CTRL_REG2_IF_ADD_INC, 4, 0x10);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG2, LPS33HW_CTRL_REG2_I2C_DIS, 3, 0x08);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG2, LPS33HW_CTRL_REG2_SWRESET, 2, 0x04);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG2, LPS33HW_CTRL_REG2_ONE_SHOT, 0, 0x01);

LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG3, LPS33HW_CTRL_REG3_INT_H_L, 7, 0x80);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG3, LPS33HW_CTRL_REG3_PP_OD, 6, 0x40);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG3, LPS33HW_CTRL_REG3_F_FSS5, 5, 0x20);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG3, LPS33HW_CTRL_REG3_F_FTH, 4, 0x10);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG3, LPS33HW_CTRL_REG3_F_OVR, 3, 0x08);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG3, LPS33HW_CTRL_REG3_DRDY, 2, 0x04);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG3, LPS33HW_CTRL_REG3_FIFO_WTM, 4, 0x10);
LPS33HW_REGISTER_VALUE(LPS33HW_CTRL_REG3, LPS33HW_CTRL_REG3_INT_S, 0, 0x03);

LPS33HW_REGISTER_VALUE(LPS33HW_FIFO_CTRL, LPS33HW_FIFO_CTRL_MODE, 5, 0xe0);
LPS33HW_REGISTER_VALUE(LPS33HW_FIFO_CTRL, LPS33HW_FIFO_WTM_THR, 0, 0x1f);
LPS33HW_REGISTER_VALUE(LPS33HW_FIFO_STATUS, LPS33HW_FIFO_FSS, 0, 0x3f);

LPS33HW_REGISTER_VALUE(LPS33HW_RES_CONF, LPS33HW_CTRL_RES_CONF_LC_EN, 0, 0x01);

LPS33HW_REGISTER_VALUE(LPS33HW_INT_SOURCE, LPS33HW_INT_SOURCE_BOOT_STATUS, 7, 0x80);
LPS33HW_REGISTER_VALUE(LPS33HW_INT_SOURCE, LPS33HW_INT_SOURCE_IA, 2, 0x04);
LPS33HW_REGISTER_VALUE(LPS33HW_INT_SOURCE, LPS33HW_INT_SOURCE_PL, 1, 0x02);
LPS33HW_REGISTER_VALUE(LPS33HW_INT_SOURCE, LPS33HW_INT_SOURCE_PH, 0, 0x01);

LPS33HW_REGISTER_VALUE(LPS33HW_STATUS, LPS33HW_STATUS_T_OR, 5, 0x20);
LPS33HW_REGISTER_VALUE(LPS33HW_STATUS, LPS33HW_STATUS_P_OR, 5, 0x10);
LPS33HW_REGISTER_VALUE(LPS33HW_STATUS, LPS33HW_STATUS_T_DA, 5, 0x02);
LPS33HW_REGISTER_VALUE(LPS33HW_STATUS, LPS33HW_STATUS_P_DA, 5, 0x01);

#define LPS33HW_WHO_AM_I_VAL (0xb1)

#ifdef __cplusplus
}
#endif

#endif /* __LPS33HW_PRIV_H__ */
