/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa.generic;

import java.security.Key;
import java.security.interfaces.EdECKey;
import java.security.spec.NamedParameterSpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class EdDSAKeyTypeDetector {
    private EdDSAKeyTypeDetector() {
        throw new IllegalStateException("No instantiation");
    }

    public static boolean isEd25519(Key key) {
        if (key == null) {
            return false;
        }
        String algorithm = key.getAlgorithm();
        if ("Ed25519".equalsIgnoreCase(algorithm)) {
            return true;
        }
        if ("EdDSA".equalsIgnoreCase(algorithm)) {
            if (key.getClass().getCanonicalName().startsWith("net.i2p.")) {
                return true;
            }
            if (key instanceof EdECKey) {
                NamedParameterSpec params = ((EdECKey)((Object)key)).getParams();
                return "Ed25519".equals(params.getName());
            }
        }
        return false;
    }
}

