/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.NamedOperation;

public class Joined<K, V, VO>
implements NamedOperation<Joined<K, V, VO>> {
    protected final Serde<K> keySerde;
    protected final Serde<V> valueSerde;
    protected final Serde<VO> otherValueSerde;
    protected final String name;
    protected final Duration gracePeriod;

    private Joined(Serde<K> keySerde, Serde<V> valueSerde, Serde<VO> otherValueSerde, String name, Duration gracePeriod) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.otherValueSerde = otherValueSerde;
        this.name = name;
        this.gracePeriod = gracePeriod;
    }

    protected Joined(Joined<K, V, VO> joined) {
        this(joined.keySerde, joined.valueSerde, joined.otherValueSerde, joined.name, joined.gracePeriod);
    }

    public static <K, V, VO> Joined<K, V, VO> with(Serde<K> keySerde, Serde<V> valueSerde, Serde<VO> otherValueSerde) {
        return new Joined<K, V, VO>(keySerde, valueSerde, otherValueSerde, null, null);
    }

    public static <K, V, VO> Joined<K, V, VO> with(Serde<K> keySerde, Serde<V> valueSerde, Serde<VO> otherValueSerde, String name) {
        return new Joined<K, V, VO>(keySerde, valueSerde, otherValueSerde, name, null);
    }

    public static <K, V, VO> Joined<K, V, VO> with(Serde<K> keySerde, Serde<V> valueSerde, Serde<VO> otherValueSerde, String name, Duration gracePeriod) {
        return new Joined<K, V, VO>(keySerde, valueSerde, otherValueSerde, name, gracePeriod);
    }

    public static <K, V, VO> Joined<K, V, VO> keySerde(Serde<K> keySerde) {
        return new Joined<K, V, VO>(keySerde, null, null, null, null);
    }

    public static <K, V, VO> Joined<K, V, VO> valueSerde(Serde<V> valueSerde) {
        return new Joined<K, V, VO>(null, valueSerde, null, null, null);
    }

    public static <K, V, VO> Joined<K, V, VO> otherValueSerde(Serde<VO> otherValueSerde) {
        return new Joined<K, V, VO>(null, null, otherValueSerde, null, null);
    }

    public static <K, V, VO> Joined<K, V, VO> as(String name) {
        return new Joined<K, V, VO>(null, null, null, name, null);
    }

    public Joined<K, V, VO> withKeySerde(Serde<K> keySerde) {
        return new Joined<K, V, VO>(keySerde, this.valueSerde, this.otherValueSerde, this.name, this.gracePeriod);
    }

    public Joined<K, V, VO> withValueSerde(Serde<V> valueSerde) {
        return new Joined<K, V, VO>(this.keySerde, valueSerde, this.otherValueSerde, this.name, this.gracePeriod);
    }

    public Joined<K, V, VO> withOtherValueSerde(Serde<VO> otherValueSerde) {
        return new Joined<K, V, VO>(this.keySerde, this.valueSerde, otherValueSerde, this.name, this.gracePeriod);
    }

    @Override
    public Joined<K, V, VO> withName(String name) {
        return new Joined<K, V, VO>(this.keySerde, this.valueSerde, this.otherValueSerde, name, this.gracePeriod);
    }

    public Joined<K, V, VO> withGracePeriod(Duration gracePeriod) {
        return new Joined<K, V, VO>(this.keySerde, this.valueSerde, this.otherValueSerde, this.name, gracePeriod);
    }

    public Duration gracePeriod() {
        return this.gracePeriod;
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public Serde<VO> otherValueSerde() {
        return this.otherValueSerde;
    }
}

