/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.error.StandardException;

class NormalizeResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private ExecRow normalizedRow;
    private int numCols;
    private int startCol;
    private final DataValueDescriptor[] cachedDestinations;
    private ResultDescription resultDescription;
    private DataTypeDescriptor[] desiredTypes;

    public NormalizeResultSet(NoPutResultSet noPutResultSet, Activation activation, int n, int n2, double d, double d2, boolean bl) throws StandardException {
        super(activation, n, d, d2);
        this.source = noPutResultSet;
        this.resultDescription = (ResultDescription)activation.getPreparedStatement().getSavedObject(n2);
        this.numCols = this.resultDescription.getColumnCount();
        this.startCol = NormalizeResultSet.computeStartColumn(bl, this.resultDescription);
        this.normalizedRow = activation.getExecutionFactory().getValueRow(this.numCols);
        this.cachedDestinations = new DataValueDescriptor[this.numCols];
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException((String)"XCL16.S", (Object[])new Object[]{"next"});
        }
        execRow = this.source.getNextRowCore();
        if (execRow != null) {
            execRow2 = this.normalizeRow(execRow);
            ++this.rowsSeen;
        }
        this.setCurrentRow(execRow2);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow2;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    public static int computeStartColumn(boolean bl, ResultDescription resultDescription) {
        int n = resultDescription.getColumnCount();
        return bl ? (n - 1) / 2 + 1 : 1;
    }

    public static DataValueDescriptor normalizeColumn(DataTypeDescriptor dataTypeDescriptor, ExecRow execRow, int n, DataValueDescriptor dataValueDescriptor, ResultDescription resultDescription) throws StandardException {
        DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(n);
        try {
            DataValueDescriptor dataValueDescriptor3 = dataTypeDescriptor.normalize(dataValueDescriptor2, dataValueDescriptor);
            return dataValueDescriptor3;
        }
        catch (StandardException standardException) {
            if (standardException.getMessageId().startsWith("23502")) {
                ResultColumnDescriptor resultColumnDescriptor = resultDescription.getColumnDescriptor(n);
                throw StandardException.newException((String)"23502", (Object[])new Object[]{resultColumnDescriptor.getName()});
            }
            throw standardException;
        }
    }

    private ExecRow normalizeRow(ExecRow execRow) throws StandardException {
        int n = this.resultDescription.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            DataValueDescriptor dataValueDescriptor = execRow.getColumn(i);
            if (dataValueDescriptor == null) continue;
            DataValueDescriptor dataValueDescriptor2 = i < this.startCol ? dataValueDescriptor : NormalizeResultSet.normalizeColumn(this.getDesiredType(i), execRow, i, this.getCachedDestination(i), this.resultDescription);
            this.normalizedRow.setColumn(i, dataValueDescriptor2);
        }
        return this.normalizedRow;
    }

    private DataValueDescriptor getCachedDestination(int n) throws StandardException {
        int n2 = n - 1;
        if (this.cachedDestinations[n2] == null) {
            this.cachedDestinations[n2] = this.getDesiredType(n).getNull();
        }
        return this.cachedDestinations[n2];
    }

    private DataTypeDescriptor getDesiredType(int n) {
        if (this.desiredTypes == null) {
            this.desiredTypes = this.fetchResultTypes(this.resultDescription);
        }
        return this.desiredTypes[n - 1];
    }

    private DataTypeDescriptor[] fetchResultTypes(ResultDescription resultDescription) {
        int n = resultDescription.getColumnCount();
        DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[n];
        for (int i = 1; i <= n; ++i) {
            DataTypeDescriptor dataTypeDescriptor;
            ResultColumnDescriptor resultColumnDescriptor = resultDescription.getColumnDescriptor(i);
            dataTypeDescriptorArray[i - 1] = dataTypeDescriptor = resultColumnDescriptor.getType();
        }
        return dataTypeDescriptorArray;
    }

    @Override
    public void updateRow(ExecRow execRow, RowChanger rowChanger) throws StandardException {
        this.source.updateRow(execRow, rowChanger);
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        this.source.markRowAsDeleted();
    }
}

