/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetBackupCompatibilityDescriptorExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetBackupCompatibilityDescriptorExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String GET_BACKUP_COMPATIBILITY_DESCRIPTOR_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.30";
    private static final byte TYPE_BASE_DN = -128;
    private static final long serialVersionUID = 8170562432854535935L;
    @NotNull
    private final String baseDN;

    public GetBackupCompatibilityDescriptorExtendedRequest(@NotNull String baseDN, Control ... controls) {
        super(GET_BACKUP_COMPATIBILITY_DESCRIPTOR_REQUEST_OID, GetBackupCompatibilityDescriptorExtendedRequest.encodeValue(baseDN), controls);
        this.baseDN = baseDN;
    }

    public GetBackupCompatibilityDescriptorExtendedRequest(@NotNull ExtendedRequest r) throws LDAPException {
        super(r);
        ASN1OctetString value = r.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_BACKUP_COMPAT_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.baseDN = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_BACKUP_COMPAT_REQUEST_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String baseDN) {
        Validator.ensureNotNull(baseDN);
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1OctetString(-128, baseDN));
        return new ASN1OctetString(valueSequence.encode());
    }

    @NotNull
    public String getBaseDN() {
        return this.baseDN;
    }

    @Override
    @NotNull
    public GetBackupCompatibilityDescriptorExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new GetBackupCompatibilityDescriptorExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public GetBackupCompatibilityDescriptorExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public GetBackupCompatibilityDescriptorExtendedRequest duplicate(@Nullable Control[] controls) {
        GetBackupCompatibilityDescriptorExtendedRequest r = new GetBackupCompatibilityDescriptorExtendedRequest(this.baseDN, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        r.setIntermediateResponseListener(this.getIntermediateResponseListener());
        r.setReferralDepth(this.getReferralDepth());
        r.setReferralConnector(this.getReferralConnectorInternal());
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_GET_BACKUP_COMPAT.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetBackupCompatibilityDescriptorExtendedRequest(baseDN='");
        buffer.append(this.baseDN);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

