/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.util.MimeMessageBodyGenerator;
import org.apache.james.vacation.api.Vacation;
import org.apache.mailet.Mail;

public class VacationReply {
    public static final String FROM_HEADER = "from";
    public static final String TO_HEADER = "to";
    private final MailAddress sender;
    private final List<MailAddress> recipients;
    private final MimeMessage mimeMessage;

    public static Builder builder(Mail originalMail) {
        return new Builder(originalMail);
    }

    private VacationReply(MailAddress sender, List<MailAddress> recipients, MimeMessage mimeMessage) {
        this.sender = sender;
        this.recipients = recipients;
        this.mimeMessage = mimeMessage;
    }

    public MailAddress getSender() {
        return this.sender;
    }

    public List<MailAddress> getRecipients() {
        return this.recipients;
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public static class Builder {
        public static final boolean NOT_REPLY_TO_ALL = false;
        private final Mail originalMail;
        private MailAddress mailRecipient;
        private Vacation vacation;

        private Builder(Mail originalMail) {
            Preconditions.checkNotNull((Object)originalMail, (Object)"Origin mail shall not be null");
            this.originalMail = originalMail;
        }

        public Builder receivedMailRecipient(MailAddress mailRecipient) {
            Preconditions.checkNotNull((Object)mailRecipient);
            this.mailRecipient = mailRecipient;
            return this;
        }

        public Builder vacation(Vacation vacation) {
            this.vacation = vacation;
            return this;
        }

        public VacationReply build(MimeMessageBodyGenerator mimeMessageBodyGenerator) throws MessagingException {
            Preconditions.checkState((this.mailRecipient != null ? 1 : 0) != 0, (Object)"Original recipient address should not be null");
            Preconditions.checkState((boolean)this.originalMail.hasSender(), (Object)"Original sender address should not be null");
            return new VacationReply(this.mailRecipient, (List<MailAddress>)this.originalMail.getMaybeSender().asList(), this.generateMimeMessage(mimeMessageBodyGenerator));
        }

        private MimeMessage generateMimeMessage(MimeMessageBodyGenerator mimeMessageBodyGenerator) throws MessagingException {
            MimeMessage reply = (MimeMessage)this.originalMail.getMessage().reply(false);
            this.vacation.getSubject().ifPresent(Throwing.consumer(subjectString -> reply.setSubject(subjectString)));
            reply.setHeader(VacationReply.FROM_HEADER, this.mailRecipient.toString());
            reply.setHeader(VacationReply.TO_HEADER, this.originalMail.getMaybeSender().get().asString());
            reply.setHeader("Auto-Submitted", "auto-replied");
            return mimeMessageBodyGenerator.from(reply, this.vacation.getTextBody(), this.vacation.getHtmlBody());
        }
    }
}

