/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.fge.lambdas.Throwing;
import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoSet;
import jakarta.inject.Inject;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.utils.ExtensionConfiguration;
import org.apache.james.utils.GuiceLoader;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.UserDefinedStartable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserStartables
implements Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserStartables.class);
    private final GuiceLoader guiceLoader;
    private final ExtensionConfiguration extensionConfiguration;

    @Inject
    public UserStartables(GuiceLoader guiceLoader, ExtensionConfiguration extensionConfiguration) {
        this.guiceLoader = guiceLoader;
        this.extensionConfiguration = extensionConfiguration;
    }

    public void start() {
        this.extensionConfiguration.getStartables().stream().map(Throwing.function(this.guiceLoader::instantiate)).peek(module -> LOGGER.info("Starting {}", (Object)module.getClass().getCanonicalName())).forEach(UserDefinedStartable::start);
    }

    public static class Module
    extends AbstractModule {
        @ProvidesIntoSet
        @Singleton
        InitializationOperation initializationOperations(UserStartables startables) {
            return InitilizationOperationBuilder.forClass(UserStartables.class).init(startables::start);
        }
    }
}

