/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.mail.internet.AddressException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaybeSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaybeSender.class);
    private final Optional<MailAddress> mailAddress;

    public static MaybeSender getMailSender(String sender) {
        if (sender == null || sender.trim().isEmpty()) {
            return MaybeSender.nullSender();
        }
        if (sender.equals("<>")) {
            return MaybeSender.nullSender();
        }
        try {
            return MaybeSender.of(new MailAddress(sender));
        }
        catch (AddressException e) {
            LOGGER.info("Unable to parse the sender address {}, so we fallback to a null sender: {}", (Object)sender, (Object)e.getMessage());
            return MaybeSender.nullSender();
        }
    }

    public static MaybeSender nullSender() {
        return new MaybeSender(Optional.empty());
    }

    public static MaybeSender of(MailAddress mailAddress) {
        return new MaybeSender(Optional.ofNullable(mailAddress).filter(Predicate.not(MailAddress::isNullSender)));
    }

    private MaybeSender(Optional<MailAddress> mailAddress) {
        this.mailAddress = mailAddress;
    }

    public Optional<MailAddress> asOptional() {
        return this.mailAddress;
    }

    public Stream<MailAddress> asStream() {
        return this.mailAddress.map(Stream::of).orElse(Stream.of(new MailAddress[0]));
    }

    public ImmutableList<MailAddress> asList() {
        return this.mailAddress.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    public MailAddress get() throws NoSuchElementException {
        return this.mailAddress.get();
    }

    public String asString() {
        return this.asString("<>");
    }

    public String asPrettyString() {
        return this.mailAddress.map(MailAddress::asPrettyString).orElse("<>");
    }

    public boolean isNullSender() {
        return !this.mailAddress.isPresent();
    }

    public String asString(String forNullValue) {
        return this.mailAddress.map(MailAddress::asString).orElse(forNullValue);
    }

    public final boolean equals(Object o) {
        if (o instanceof MaybeSender) {
            MaybeSender that = (MaybeSender)o;
            return Objects.equals(this.mailAddress, that.mailAddress);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.mailAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("mailAddress", this.mailAddress).toString();
    }
}

