/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.nio.channels.Selector;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.zeromq.ZMQ;

public class ZContext
implements Closeable {
    private ZMQ.Context context;
    private final List<ZMQ.Socket> sockets = new CopyOnWriteArrayList<ZMQ.Socket>();
    private final int ioThreads;
    private final boolean main;
    private int linger;
    private int pipehwm;
    private int sndhwm;
    private int rcvhwm;
    private final Lock mutex = new ReentrantLock();

    public ZContext() {
        this(1);
    }

    public ZContext(int ioThreads) {
        this(null, true, ioThreads);
    }

    private ZContext(ZMQ.Context context, boolean main, int ioThreads) {
        this.context = context;
        this.ioThreads = ioThreads;
        this.main = main;
        this.linger = 0;
        this.pipehwm = 1000;
        this.sndhwm = 1000;
        this.rcvhwm = 1000;
    }

    public void destroy() {
        for (ZMQ.Socket socket : this.sockets) {
            this.destroySocket(socket);
        }
        this.sockets.clear();
        if (this.isMain() && this.context != null) {
            this.context.term();
            this.context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZMQ.Socket createSocket(int type) {
        ZMQ.Socket socket = this.getContext().socket(type);
        socket.setRcvHWM(this.rcvhwm);
        socket.setSndHWM(this.sndhwm);
        try {
            this.mutex.lock();
            this.sockets.add(socket);
        }
        finally {
            this.mutex.unlock();
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySocket(ZMQ.Socket s2) {
        if (s2 == null) {
            return;
        }
        s2.setLinger(this.linger);
        s2.close();
        try {
            this.mutex.lock();
            this.sockets.remove(s2);
        }
        finally {
            this.mutex.unlock();
        }
    }

    public Selector createSelector() {
        return this.getContext().selector();
    }

    public ZMQ.Poller createPoller(int size) {
        return new ZMQ.Poller(this.getContext(), size);
    }

    public static ZContext shadow(ZContext ctx) {
        ZContext context = new ZContext(ctx.getContext(), false, ctx.ioThreads);
        context.linger = ctx.linger;
        context.sndhwm = ctx.sndhwm;
        context.rcvhwm = ctx.rcvhwm;
        context.pipehwm = ctx.pipehwm;
        return context;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    @Deprecated
    public void setIoThreads(int ioThreads) {
    }

    public int getLinger() {
        return this.linger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinger(int linger) {
        try {
            this.mutex.lock();
            this.linger = linger;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRcvHWM(int rcvhwm) {
        try {
            this.mutex.lock();
            this.rcvhwm = rcvhwm;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSndHWM(int sndhwm) {
        try {
            this.mutex.lock();
            this.sndhwm = sndhwm;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public boolean isMain() {
        return this.main;
    }

    @Deprecated
    public void setMain(boolean main) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZMQ.Context getContext() {
        try {
            this.mutex.lock();
            if (this.context == null) {
                this.context = ZMQ.context(this.ioThreads);
            }
        }
        finally {
            this.mutex.unlock();
        }
        return this.context;
    }

    @Deprecated
    public void setContext(ZMQ.Context ctx) {
    }

    public List<ZMQ.Socket> getSockets() {
        return this.sockets;
    }

    @Override
    public void close() {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ZContext zContext = this;
        synchronized (zContext) {
            if (this.context == null) {
                return true;
            }
            return this.context.isClosed();
        }
    }
}

