<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Security Policy

The Apache Security Team handles all security issues across Apache projects and
coordinates the response to vulnerabilities. For details on the vulnerability
handling process, supported versions, and what is considered a security issue,
visit: https://www.apache.org/security/.

## Do not

For better collaboration, we hope you:

- DO NOT report non-security-impacting bugs through this channel. If you have
  any questions on using, development, please use [GitHub
  Issues](https://github.com/apache/cloudberry/issues),
  [Discussions](https://github.com/apache/cloudberry/discussions), [Dev mailing
  list](https://cloudberry.apache.org/community/mailing-lists) or
  [Slack](https://inviter.co/apache-cloudberry) instead.
- DO NOT report security issues on public GitHub Issues, Jira tickets, mailing
  lists, or other public forums.

## Reporting Security Issues

Send your report to: [security@apache.org](mailto:security@apache.org).

Please send one plain-text email per vulnerability with the following and
additional information as necessary (as much as you can provide):

- Description of the vulnerability
- Steps to reproduce
- Affected versions
- Potential impact
- Any known mitigations
- (Optional) Suggested fix

## Public Discussion

For general security questions or discussions, please use the development
mailing list: [dev@cloudberry.apache.org](mailto:dev@cloudberry.apache.org)

## Preferred Languages

We prefer all communications to be in English.
