/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.creation.proxy.ProxyRealMethod;
import org.mockito.internal.debugging.LocationFactory;
import org.mockito.internal.invocation.DefaultInvocationFactory;
import org.mockito.internal.invocation.RealMethod;
import org.mockito.internal.util.Platform;
import org.mockito.internal.util.StringUtil;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;

public class ProxyMockMaker
implements MockMaker {
    private static final Object[] EMPTY = new Object[0];
    private final ProxyRealMethod proxyRealMethod = ProxyRealMethod.make();

    @Override
    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        boolean object = settings.getTypeToMock() == Object.class;
        Class[] ifaces = new Class[settings.getExtraInterfaces().size() + (object ? 0 : 1)];
        int index = 0;
        if (!object) {
            ifaces[index++] = settings.getTypeToMock();
        }
        ClassLoader classLoader = settings.getTypeToMock().getClassLoader();
        for (Class<?> iface : settings.getExtraInterfaces()) {
            ifaces[index++] = iface;
            classLoader = ProxyMockMaker.resolveCommonClassLoader(classLoader, iface);
        }
        return (T)Proxy.newProxyInstance(ProxyMockMaker.resolveCommonClassLoader(classLoader, ProxyMockMaker.class), ifaces, (InvocationHandler)new MockInvocationHandler(handler, settings));
    }

    private static ClassLoader resolveCommonClassLoader(ClassLoader mostSpecific, Class<?> type) {
        if (mostSpecific == null) {
            return type.getClassLoader();
        }
        ClassLoader candidate = type.getClassLoader();
        if (candidate == null || mostSpecific == candidate) {
            return mostSpecific;
        }
        while (candidate != null) {
            if (candidate == mostSpecific) {
                return type.getClassLoader();
            }
            candidate = candidate.getParent();
        }
        for (candidate = mostSpecific; candidate != null; candidate = candidate.getParent()) {
            if (candidate != type.getClassLoader()) continue;
            return mostSpecific;
        }
        return new CommonClassLoader(mostSpecific, type.getClassLoader());
    }

    @Override
    public MockHandler getHandler(Object mock) {
        if (!Proxy.isProxyClass(mock.getClass())) {
            return null;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(mock);
        if (!(handler instanceof MockInvocationHandler)) {
            return null;
        }
        return ((MockInvocationHandler)handler).handler.get();
    }

    @Override
    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        ((MockInvocationHandler)Proxy.getInvocationHandler((Object)mock)).handler.set(newHandler);
    }

    @Override
    public MockMaker.TypeMockability isTypeMockable(final Class<?> type) {
        return new MockMaker.TypeMockability(){

            @Override
            public boolean mockable() {
                return type.isInterface() || type == Object.class;
            }

            @Override
            public String nonMockableReason() {
                return this.mockable() ? "" : "non-interface";
            }
        };
    }

    private class MockInvocationHandler
    implements InvocationHandler {
        private final AtomicReference<MockHandler<?>> handler;
        private final MockCreationSettings<?> settings;

        private MockInvocationHandler(MockHandler<?> handler, MockCreationSettings<?> settings) {
            this.handler = new AtomicReference(handler);
            this.settings = settings;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args == null) {
                args = EMPTY;
            }
            if (method.getDeclaringClass() == Object.class) {
                switch (method.getName()) {
                    case "hashCode": {
                        return System.identityHashCode(proxy);
                    }
                    case "equals": {
                        return proxy == args[0];
                    }
                    case "toString": {
                        break;
                    }
                    default: {
                        throw new MockitoException(StringUtil.join("Unexpected overridable method of Object class found", "", "The method " + String.valueOf(method) + " was not expected to be declared. Either your JVM build offers non-official API or the current functionality is not supported", Platform.describe()));
                    }
                }
            }
            RealMethod realMethod = Modifier.isAbstract(method.getModifiers()) ? RealMethod.IsIllegal.INSTANCE : ProxyMockMaker.this.proxyRealMethod.resolve(proxy, method, args);
            return this.handler.get().handle(DefaultInvocationFactory.createInvocation(proxy, method, args, realMethod, this.settings, LocationFactory.create()));
        }
    }

    private static class CommonClassLoader
    extends ClassLoader {
        private final ClassLoader left;
        private final ClassLoader right;

        private CommonClassLoader(ClassLoader left, ClassLoader right) {
            super(null);
            this.left = left;
            this.right = right;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.left.loadClass(name);
            }
            catch (ClassNotFoundException ignored) {
                return this.right.loadClass(name);
            }
        }
    }
}

