/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.placementdriver.negotiation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.lang.ComponentStoppingException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteThrottledLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.placementdriver.leases.Lease;
import org.apache.ignite3.internal.placementdriver.message.LeaseGrantedMessageResponse;
import org.apache.ignite3.internal.placementdriver.message.PlacementDriverMessagesFactory;
import org.apache.ignite3.internal.placementdriver.negotiation.LeaseAgreement;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.util.ExceptionUtils;

public class LeaseNegotiator {
    private static final PlacementDriverMessagesFactory PLACEMENT_DRIVER_MESSAGES_FACTORY = new PlacementDriverMessagesFactory();
    private final IgniteThrottledLogger log = Loggers.toThrottledLogger(Loggers.forClass(LeaseNegotiator.class), Runnable::run);
    private final Map<ReplicationGroupId, LeaseAgreement> leaseToNegotiate = new ConcurrentHashMap<ReplicationGroupId, LeaseAgreement>();
    private final ClusterService clusterService;

    public LeaseNegotiator(ClusterService clusterService, Executor throttledLogExecutor) {
        this.clusterService = clusterService;
    }

    public void negotiate(LeaseAgreement agreement) {
        Lease lease = agreement.getLease();
        long leaseInterval = lease.getExpirationTime().getPhysical() - lease.getStartTime().getPhysical();
        this.leaseToNegotiate.put(agreement.groupId(), agreement);
        this.clusterService.messagingService().invoke(lease.getLeaseholder(), (NetworkMessage)PLACEMENT_DRIVER_MESSAGES_FACTORY.leaseGrantedMessage().groupId(agreement.groupId()).leaseStartTime(lease.getStartTime()).leaseExpirationTime(lease.getExpirationTime()).force(agreement.forced()).build(), leaseInterval).whenComplete((msg, throwable) -> {
            if (throwable == null) {
                assert (msg instanceof LeaseGrantedMessageResponse) : "Message type is unexpected [type=" + msg.getClass().getSimpleName() + "]";
                LeaseGrantedMessageResponse response = (LeaseGrantedMessageResponse)msg;
                agreement.onResponse(response);
            } else {
                if (!ExceptionUtils.hasCause(throwable, NodeStoppingException.class, ComponentStoppingException.class)) {
                    this.log.warn("Lease was not negotiated due to exception", () -> IgniteStringFormatter.format("Lease was not negotiated due to exception [lease={}]", lease), (Throwable)throwable);
                }
                this.leaseToNegotiate.remove(agreement.groupId(), agreement);
                agreement.cancel();
            }
        });
    }

    public LeaseAgreement getAndRemoveIfReady(ReplicationGroupId groupId) {
        LeaseAgreement[] res = new LeaseAgreement[1];
        this.leaseToNegotiate.compute(groupId, (k, v) -> {
            res[0] = v;
            return v != null && v.ready() ? null : v;
        });
        return res[0] == null ? LeaseAgreement.UNDEFINED_AGREEMENT : res[0];
    }

    public void cancelAgreement(ReplicationGroupId groupId) {
        LeaseAgreement agreement = this.leaseToNegotiate.remove(groupId);
        if (agreement != null) {
            agreement.cancel();
        }
    }
}

