/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.OperationBuilder;
import org.apache.ignite3.internal.metastorage.dsl.OperationSerializer;
import org.apache.ignite3.internal.metastorage.dsl.OperationType;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class OperationImpl
implements Operation,
Cloneable {
    public static final short GROUP_TYPE = 222;
    public static final short TYPE = 5;
    @IgniteToStringInclude
    private final ByteBuffer key;
    @IgniteToStringInclude
    private final OperationType type;
    @IgniteToStringInclude
    private final ByteBuffer value;

    private OperationImpl(ByteBuffer key, OperationType type, ByteBuffer value) {
        this.key = key;
        this.type = type;
        this.value = value;
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    @Override
    public OperationType type() {
        return this.type;
    }

    @Override
    public ByteBuffer value() {
        return this.value;
    }

    public MessageSerializer serializer() {
        return OperationSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 222;
    }

    public String toString() {
        return S.toString(OperationImpl.class, this);
    }

    @Override
    public short messageType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OperationImpl otherMessage = (OperationImpl)other;
        return Objects.equals(this.key, otherMessage.key) && Objects.equals((Object)this.type, (Object)otherMessage.type) && Objects.equals(this.value, otherMessage.value);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.key, this.type, this.value});
        return result;
    }

    @Override
    public OperationImpl clone() {
        try {
            return (OperationImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static OperationBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements OperationBuilder {
        private ByteBuffer key;
        private OperationType type;
        private ByteBuffer value;

        private Builder() {
        }

        @Override
        public OperationBuilder key(ByteBuffer key) {
            this.key = key;
            return this;
        }

        @Override
        public OperationBuilder type(OperationType type) {
            Objects.requireNonNull(type, "type is not marked @Nullable");
            this.type = type;
            return this;
        }

        @Override
        public OperationBuilder value(ByteBuffer value) {
            this.value = value;
            return this;
        }

        @Override
        public ByteBuffer key() {
            return this.key;
        }

        @Override
        public OperationType type() {
            return this.type;
        }

        @Override
        public ByteBuffer value() {
            return this.value;
        }

        @Override
        public Operation build() {
            return new OperationImpl(this.key, Objects.requireNonNull(this.type, "type is not marked @Nullable"), this.value);
        }
    }
}

