/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.message;

import org.apache.ignite3.internal.compute.ComputeMessagesFactory;
import org.apache.ignite3.internal.compute.message.JobStatesResponse;
import org.apache.ignite3.internal.compute.message.JobStatesResponseBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class JobStatesResponseDeserializer
implements MessageDeserializer<JobStatesResponse> {
    private final JobStatesResponseBuilder msg;

    JobStatesResponseDeserializer(ComputeMessagesFactory messageFactory) {
        this.msg = messageFactory.jobStatesResponse();
    }

    @Override
    public Class<JobStatesResponse> klass() {
        return JobStatesResponse.class;
    }

    @Override
    public JobStatesResponse getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("statesByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.statesByteArray(tmp);
                reader.incrementState();
            }
            case 1: {
                byte[] tmp = reader.readByteArray("throwableByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.throwableByteArray(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(JobStatesResponse.class);
    }
}

