/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.plugin;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridPluginContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.Extension;
import org.apache.ignite.plugin.ExtensionRegistry;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.jetbrains.annotations.Nullable;

public class IgnitePluginProcessor
extends GridProcessorAdapter {
    private final Map<String, PluginProvider> plugins = new LinkedHashMap<String, PluginProvider>();
    private final Map<PluginProvider, GridPluginContext> pluginCtxMap = new IdentityHashMap<PluginProvider, GridPluginContext>();
    private volatile Map<Class<?>, Object[]> extensions;

    public IgnitePluginProcessor(GridKernalContext ctx, IgniteConfiguration cfg, List<PluginProvider> providers) throws IgniteCheckedException {
        super(ctx);
        ExtensionRegistryImpl registry = new ExtensionRegistryImpl();
        for (PluginProvider provider : providers) {
            GridPluginContext pluginCtx = new GridPluginContext(ctx, cfg);
            if (F.isEmpty(provider.name())) {
                throw new IgniteException("Plugin name can not be empty.");
            }
            if (this.plugins.containsKey(provider.name())) {
                throw new IgniteException("Duplicated plugin name: " + provider.name());
            }
            this.plugins.put(provider.name(), provider);
            this.pluginCtxMap.put(provider, pluginCtx);
            provider.initExtensions(pluginCtx, registry);
            if (provider.plugin() != null) continue;
            throw new IgniteException("Plugin is null.");
        }
        this.extensions = registry.createExtensionMap();
    }

    @Nullable
    public <T extends Extension> T[] extensions(Class<T> extensionItf) {
        Map<Class<?>, Object[]> extensions = this.extensions;
        return (Extension[])extensions.get(extensionItf);
    }

    @Nullable
    public <T extends PluginProvider> T pluginProvider(String name) {
        return (T)this.plugins.get(name);
    }

    public Collection<PluginProvider> allProviders() {
        return this.plugins.values();
    }

    public <T extends PluginContext> T pluginContextForProvider(PluginProvider provider) {
        return (T)this.pluginCtxMap.get(provider);
    }

    public <T> T createComponent(Class<T> cls) {
        for (PluginProvider plugin : this.plugins.values()) {
            T ctx;
            T comp = plugin.createComponent((PluginContext)(ctx = this.pluginContextForProvider(plugin)), cls);
            if (comp == null) continue;
            return comp;
        }
        return null;
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ackPluginsInfo();
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.PLUGIN;
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        Serializable pluginsData = this.getDiscoveryData(dataBag.joiningNodeId());
        if (pluginsData != null) {
            dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.PLUGIN.ordinal(), pluginsData);
        }
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        Serializable pluginsData = this.getDiscoveryData(dataBag.joiningNodeId());
        if (pluginsData != null) {
            dataBag.addNodeSpecificData(GridComponent.DiscoveryDataExchangeType.PLUGIN.ordinal(), pluginsData);
        }
    }

    private Serializable getDiscoveryData(UUID joiningNodeId) {
        HashMap<String, Serializable> pluginsData = null;
        for (Map.Entry<String, PluginProvider> e : this.plugins.entrySet()) {
            Serializable data = e.getValue().provideDiscoveryData(joiningNodeId);
            if (data == null) continue;
            if (pluginsData == null) {
                pluginsData = new HashMap<String, Serializable>();
            }
            pluginsData.put(e.getKey(), data);
        }
        return pluginsData;
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        if (data.hasJoiningNodeData()) {
            Map pluginsData = (Map)((Object)data.joiningNodeData());
            this.applyPluginsData(data.joiningNodeId(), pluginsData);
        }
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        Map<UUID, Serializable> nodeSpecificData = data.nodeSpecificData();
        if (nodeSpecificData != null) {
            UUID joiningNodeId = data.joiningNodeId();
            for (Serializable v : nodeSpecificData.values()) {
                if (v == null) continue;
                Map pluginsData = (Map)((Object)v);
                this.applyPluginsData(joiningNodeId, pluginsData);
            }
        }
    }

    private void applyPluginsData(UUID nodeId, Map<String, Serializable> pluginsData) {
        for (Map.Entry<String, Serializable> e : pluginsData.entrySet()) {
            PluginProvider provider = this.plugins.get(e.getKey());
            if (provider != null) {
                provider.receiveDiscoveryData(nodeId, e.getValue());
                continue;
            }
            U.warn(this.log, "Received discovery data for unknown plugin: " + e.getKey());
        }
    }

    private void ackPluginsInfo() {
        U.quietAndInfo(this.log, "Configured plugins:");
        if (this.plugins.isEmpty()) {
            U.quietAndInfo(this.log, "  ^-- None");
            U.quietAndInfo(this.log, "");
        } else {
            for (PluginProvider plugin : this.plugins.values()) {
                U.quietAndInfo(this.log, "  ^-- " + plugin.name() + " " + plugin.version());
                U.quietAndInfo(this.log, "  ^-- " + plugin.copyright());
                U.quietAndInfo(this.log, "");
            }
        }
    }

    private static class ExtensionRegistryImpl
    implements ExtensionRegistry {
        private final Map<Class<?>, List<Object>> extensionsCollector = new HashMap();

        private ExtensionRegistryImpl() {
        }

        @Override
        public <T extends Extension> void registerExtension(Class<T> extensionItf, T extensionImpl) {
            List<Object> list = this.extensionsCollector.get(extensionItf);
            if (list == null) {
                list = new ArrayList<Object>();
                this.extensionsCollector.put(extensionItf, list);
            }
            list.add(extensionImpl);
        }

        Map<Class<?>, Object[]> createExtensionMap() {
            HashMap extensions = new HashMap(this.extensionsCollector.size() * 2, 0.5f);
            for (Map.Entry<Class<?>, List<Object>> entry : this.extensionsCollector.entrySet()) {
                Class<?> extensionItf = entry.getKey();
                List<Object> implementations = entry.getValue();
                Object[] implArr = (Object[])Array.newInstance(extensionItf, implementations.size());
                implArr = implementations.toArray(implArr);
                extensions.put(extensionItf, implArr);
            }
            return extensions;
        }
    }
}

