/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.PlatformTargetProxyImpl;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractJob;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformComputeTaskSession;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.resources.TaskSessionResource;
import org.jetbrains.annotations.Nullable;

public class PlatformFullJob
extends PlatformAbstractJob {
    private static final long serialVersionUID = 0L;
    private static final byte STATE_INIT = 0;
    private static final byte STATE_RUNNING = 1;
    private static final byte STATE_COMPLETED = 2;
    private static final byte STATE_CANCELLED = 3;
    private transient PlatformContext ctx;
    private transient byte state;
    @TaskSessionResource
    private transient ComputeTaskSession ses;

    public PlatformFullJob() {
    }

    public PlatformFullJob(PlatformContext ctx, PlatformAbstractTask task, long ptr, Object job, String jobName) {
        super(task, ptr, job, jobName);
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object execute0(PlatformContext ctx) throws IgniteCheckedException {
        boolean cancel = false;
        PlatformFullJob platformFullJob = this;
        synchronized (platformFullJob) {
            if (this.task == null) {
                assert (this.ptr == 0L);
                this.createJob(ctx);
            } else assert (this.ptr != 0L);
            if (this.state == 0) {
                this.state = 1;
            } else {
                assert (this.state == 3);
                cancel = true;
            }
        }
        try {
            PlatformComputeTaskSession platformSes = new PlatformComputeTaskSession(ctx, this.ses);
            PlatformTargetProxyImpl platformSesProxy = new PlatformTargetProxyImpl(platformSes, ctx);
            if (this.task != null) {
                Object object = this.runLocal(ctx, cancel, platformSesProxy);
                return object;
            }
            PlatformMemory mem = ctx.memory().allocate();
            try {
                PlatformOutputStream out = mem.output();
                out.writeLong(this.ptr);
                out.writeBoolean(cancel);
                out.synchronize();
                ctx.gateway().computeJobExecute(mem.pointer(), platformSesProxy);
                PlatformInputStream in = mem.input();
                in.synchronize();
                BinaryRawReaderEx reader = ctx.reader(in);
                Object object = PlatformUtils.readInvocationResult(ctx, reader);
                if (mem != null) {
                    mem.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                if (mem != null) {
                    try {
                        mem.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            PlatformFullJob platformFullJob2 = this;
            synchronized (platformFullJob2) {
                if (this.task == null) {
                    assert (this.ptr != 0L);
                    ctx.gateway().computeJobDestroy(this.ptr);
                }
                if (this.state == 1) {
                    this.state = (byte)2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        PlatformProcessor proc = PlatformUtils.platformProcessor(this.ignite);
        PlatformFullJob platformFullJob = this;
        synchronized (platformFullJob) {
            if (this.state == 0) {
                this.state = (byte)3;
            } else if (this.state == 1) {
                assert (this.ptr != 0L);
                try {
                    proc.context().gateway().computeJobCancel(this.ptr);
                }
                finally {
                    this.state = (byte)3;
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        block10: {
            if (this.job == null) {
                assert (this.ptr != 0L);
                try {
                    if (this.task != null) {
                        if (this.task.onJobLock()) {
                            try {
                                this.serialize();
                                break block10;
                            }
                            finally {
                                this.task.onJobUnlock();
                            }
                        }
                        throw new IgniteCheckedException("Task already completed: " + this.task);
                    }
                    this.serialize();
                }
                catch (IgniteCheckedException e) {
                    throw new IOException("Failed to serialize interop job.", e);
                }
            }
        }
        assert (this.job != null);
        out.writeObject(this.job);
        out.writeObject(this.jobName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.job = in.readObject();
        this.jobName = (String)in.readObject();
    }

    private void serialize() throws IgniteCheckedException {
        block7: {
            try (PlatformMemory mem = this.ctx.memory().allocate();){
                PlatformInputStream in = mem.input();
                boolean res = this.ctx.gateway().computeJobSerialize(this.ptr, mem.pointer()) == 1;
                in.synchronize();
                BinaryRawReaderEx reader = this.ctx.reader(in);
                if (res) {
                    this.job = reader.readObjectDetached();
                    break block7;
                }
                throw new IgniteCheckedException(reader.readString());
            }
        }
    }
}

