/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.service;

import java.util.Collection;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.services.PlatformService;
import org.apache.ignite.services.ServiceDescriptor;

public class ClientServiceDescriptorsResponse
extends ClientResponse {
    private final Collection<ServiceDescriptor> svcs;

    public ClientServiceDescriptorsResponse(long reqId, Collection<ServiceDescriptor> svcs) {
        super(reqId);
        this.svcs = svcs;
    }

    @Override
    public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
        super.encode(ctx, writer);
        ClientUtils.collection(this.svcs, writer.out(), (out, svc) -> ClientServiceDescriptorsResponse.writeDescriptor(writer, svc));
    }

    public static void writeDescriptor(BinaryRawWriterEx writer, ServiceDescriptor svc) {
        writer.writeString(svc.name());
        writer.writeString(svc.serviceClass().getName());
        writer.writeInt(svc.totalCount());
        writer.writeInt(svc.maxPerNodeCount());
        writer.writeString(svc.cacheName());
        writer.writeUuid(svc.originNodeId());
        writer.writeByte(PlatformService.class.isAssignableFrom(svc.serviceClass()) ? (byte)1 : 0);
    }
}

