/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import org.apache.ignite.internal.processors.metric.MetricRegistryImpl;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.IntMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.odbc.ClientListenerNioListener;

public class ClientListenerMetrics {
    public static final String METRIC_REJECTED_TIMEOUT = "RejectedSessionsTimeout";
    public static final String METRIC_REJECTED_AUTHENTICATION = "RejectedSessionsAuthenticationFailed";
    public static final String METRIC_REJECTED_TOTAL = "RejectedSessionsTotal";
    public static final String METRIC_ACEPTED = "AcceptedSessions";
    public static final String AFF_KEY_HITS = "AffinityKeyRequestsHits";
    public static final String AFF_KEY_MISSES = "AffinityKeyRequestsMisses";
    public static final String AFF_QRY_HITS = "AffinityQueryRequestsHits";
    public static final String AFF_QRY_MISSES = "AffinityQueryRequestsMisses";
    private final IntMetricImpl rejectedTimeout;
    private final IntMetricImpl rejectedAuth;
    private final IntMetricImpl rejectedTotal;
    private final IntMetricImpl[] accepted;
    private final LongAdderMetric affKeyHits;
    private final LongAdderMetric affKeyMisses;
    private final AtomicLongMetric affQryHits;
    private final AtomicLongMetric affQryMisses;

    public ClientListenerMetrics(MetricRegistryImpl mreg) {
        this.rejectedTimeout = mreg.intMetric(METRIC_REJECTED_TIMEOUT, "TCP sessions count that were rejected due to handshake timeout.");
        this.rejectedAuth = mreg.intMetric(METRIC_REJECTED_AUTHENTICATION, "TCP sessions count that were rejected due to failed authentication.");
        this.rejectedTotal = mreg.intMetric(METRIC_REJECTED_TOTAL, "Total number of rejected TCP connections.");
        this.accepted = new IntMetricImpl[ClientListenerNioListener.CLI_TYPES.length];
        this.affKeyHits = mreg.longAdderMetric(AFF_KEY_HITS, "The number of affinity-aware cache key requests that were sent to the primary node");
        this.affKeyMisses = mreg.longAdderMetric(AFF_KEY_MISSES, "The number of affinity-aware cache key requests that were sent not to the primary node");
        this.affQryHits = mreg.longMetric(AFF_QRY_HITS, "The number of affinity-aware query requests that were sent to the primary node");
        this.affQryMisses = mreg.longMetric(AFF_QRY_MISSES, "The number of affinity-aware query requests that were sent not to the primary node");
        for (byte clientType : ClientListenerNioListener.CLI_TYPES) {
            String clientLbl = ClientListenerMetrics.clientTypeLabel(clientType);
            String lblAccepted = MetricUtils.metricName(clientLbl, METRIC_ACEPTED);
            this.accepted[clientType] = mreg.intMetric(lblAccepted, "Number of successfully established sessions for the client type.");
        }
    }

    public void onHandshakeTimeout() {
        this.rejectedTimeout.increment();
        this.rejectedTotal.increment();
    }

    public void onFailedAuth() {
        this.rejectedAuth.increment();
        this.rejectedTotal.increment();
    }

    public void onGeneralReject() {
        this.rejectedTotal.increment();
    }

    public void onHandshakeAccept(byte clientType) {
        this.accepted[clientType].increment();
    }

    public void onAffinityKeyHit() {
        this.affKeyHits.increment();
    }

    public void onAffinityKeyMiss() {
        this.affKeyMisses.increment();
    }

    public void onAffinityQryHit() {
        this.affQryHits.increment();
    }

    public void onAffinityQryMiss() {
        this.affQryMisses.increment();
    }

    public static String clientTypeLabel(byte clientType) {
        switch (clientType) {
            case 0: {
                return "odbc";
            }
            case 1: {
                return "jdbc";
            }
            case 2: {
                return "thin";
            }
        }
        return "unknown";
    }
}

