/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public enum GridClientCacheFlag {
    SKIP_STORE,
    KEEP_BINARIES;

    public static final int SKIP_STORE_MASK = 1;
    public static final int KEEP_BINARIES_MASK = 2;
    private static final GridClientCacheFlag[] VALS;

    public static GridClientCacheFlag fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    public static int encodeCacheFlags(Collection<GridClientCacheFlag> flagSet) {
        int bits = 0;
        if (flagSet.contains((Object)SKIP_STORE)) {
            bits |= 1;
        }
        if (flagSet.contains((Object)KEEP_BINARIES)) {
            bits |= 2;
        }
        return bits;
    }

    public static Set<GridClientCacheFlag> parseCacheFlags(int cacheFlagsBits) {
        boolean keepBinaries;
        boolean skipStore = (cacheFlagsBits & 1) != 0;
        boolean bl = keepBinaries = (cacheFlagsBits & 2) != 0;
        if (skipStore & keepBinaries) {
            return EnumSet.of(SKIP_STORE, KEEP_BINARIES);
        }
        if (skipStore) {
            return EnumSet.of(SKIP_STORE);
        }
        if (keepBinaries) {
            return EnumSet.of(KEEP_BINARIES);
        }
        return EnumSet.noneOf(GridClientCacheFlag.class);
    }

    static {
        VALS = GridClientCacheFlag.values();
    }
}

