/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.control;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.control.FlowControl;
import com.facebook.presto.bytecode.instruction.LabelNode;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class DoWhileLoop
implements FlowControl {
    private final String comment;
    private final BytecodeBlock body = new BytecodeBlock();
    private final BytecodeBlock condition = new BytecodeBlock();
    private final LabelNode beginLabel = new LabelNode("begin");
    private final LabelNode continueLabel = new LabelNode("continue");
    private final LabelNode endLabel = new LabelNode("end");

    public DoWhileLoop() {
        this.comment = null;
    }

    public DoWhileLoop(String format, Object ... args) {
        this.comment = String.format(format, args);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public LabelNode getContinueLabel() {
        return this.continueLabel;
    }

    public LabelNode getEndLabel() {
        return this.endLabel;
    }

    public BytecodeBlock body() {
        return this.body;
    }

    public DoWhileLoop body(BytecodeNode node) {
        BytecodeUtils.checkState(this.body.isEmpty(), "body already set");
        this.body.append(node);
        return this;
    }

    public BytecodeBlock condition() {
        return this.condition;
    }

    public DoWhileLoop condition(BytecodeNode node) {
        BytecodeUtils.checkState(this.condition.isEmpty(), "condition already set");
        this.condition.append(node);
        return this;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        BytecodeUtils.checkState(!this.condition.isEmpty(), "DoWhileLoop does not have a condition set");
        BytecodeBlock block = new BytecodeBlock().visitLabel(this.beginLabel).append(new BytecodeBlock().setDescription("body").append(this.body)).visitLabel(this.continueLabel).append(new BytecodeBlock().setDescription("condition").append(this.condition)).ifFalseGoto(this.endLabel).gotoLabel(this.beginLabel).visitLabel(this.endLabel);
        block.accept(visitor, generationContext);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of(this.body, this.condition);
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitDoWhile(parent, this);
    }
}

