/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorAbstractAvg;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorHelper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorDecimalAvg
extends VectorPTFEvaluatorAbstractAvg<HiveDecimalWritable> {
    protected HiveDecimalWritable temp;
    protected HiveDecimalWritable avg;

    public VectorPTFEvaluatorDecimalAvg(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.sum = new HiveDecimalWritable();
        this.temp = new HiveDecimalWritable();
        this.avg = new HiveDecimalWritable();
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DecimalColumnVector decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
        if (decimalColVector.isRepeating) {
            if (decimalColVector.noNulls || !decimalColVector.isNull[0]) {
                this.temp.setFromLong((long)batch.size);
                if (this.isGroupResultNull) {
                    ((HiveDecimalWritable)this.sum).set(decimalColVector.vector[0]);
                    ((HiveDecimalWritable)this.sum).mutateMultiply(this.temp);
                    this.isGroupResultNull = false;
                } else {
                    this.temp.mutateMultiply(decimalColVector.vector[0]);
                    ((HiveDecimalWritable)this.sum).mutateAdd(this.temp);
                }
                this.nonNullGroupCount += size;
            }
        } else if (decimalColVector.noNulls) {
            HiveDecimalWritable[] vector = decimalColVector.vector;
            if (this.isGroupResultNull) {
                ((HiveDecimalWritable)this.sum).set(vector[0]);
                this.isGroupResultNull = false;
            } else {
                ((HiveDecimalWritable)this.sum).mutateAdd(vector[0]);
            }
            for (int i = 1; i < size; ++i) {
                ((HiveDecimalWritable)this.sum).mutateAdd(vector[i]);
            }
            this.nonNullGroupCount += size;
        } else {
            boolean[] batchIsNull = decimalColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (++i < size) continue;
                return;
            }
            HiveDecimalWritable[] vector = decimalColVector.vector;
            if (this.isGroupResultNull) {
                ((HiveDecimalWritable)this.sum).set(vector[i++]);
                this.isGroupResultNull = false;
            } else {
                ((HiveDecimalWritable)this.sum).mutateAdd(vector[i++]);
            }
            ++this.nonNullGroupCount;
            while (i < size) {
                if (!batchIsNull[i]) {
                    ((HiveDecimalWritable)this.sum).mutateAdd(vector[i]);
                    ++this.nonNullGroupCount;
                }
                ++i;
            }
        }
    }

    @Override
    public void doLastBatchWork() {
        if (!this.isGroupResultNull) {
            this.avg.set((HiveDecimalWritable)this.sum);
            this.temp.setFromLong((long)this.nonNullGroupCount);
            this.avg.mutateDivide(this.temp);
        }
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public Object getGroupResult() {
        this.doLastBatchWork();
        return this.avg;
    }

    @Override
    protected HiveDecimalWritable computeValue(HiveDecimalWritable number) {
        return VectorPTFEvaluatorHelper.computeValue(number);
    }

    @Override
    public HiveDecimalWritable plus(HiveDecimalWritable t1, HiveDecimalWritable t2) {
        return VectorPTFEvaluatorHelper.plus(t1, t2);
    }

    @Override
    public HiveDecimalWritable minus(HiveDecimalWritable t1, HiveDecimalWritable t2) {
        return VectorPTFEvaluatorHelper.minus(t1, t2);
    }

    protected HiveDecimalWritable divide(HiveDecimalWritable number, long divisor) {
        return VectorPTFEvaluatorHelper.divide(number, divisor);
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        ((HiveDecimalWritable)this.sum).set(HiveDecimal.ZERO);
        this.nonNullGroupCount = 0;
        this.avg.set(HiveDecimal.ZERO);
    }
}

