/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplStatsTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ReplStatsTracker.class);
    public static int RM_PROGRESS_LENGTH = 10000;
    public static int TOP_K_MAX = 10;
    private ConcurrentHashMap<String, DescriptiveStatistics> descMap;
    private ConcurrentHashMap<String, ListOrderedMap<Long, Long>> topKEvents;
    private final int k;
    private String lastEventId;

    public ReplStatsTracker(int k) {
        if (k > TOP_K_MAX) {
            LOG.warn("Value for {} exceeded maximum permissible limit. Using Maximum of {}", (Object)HiveConf.ConfVars.REPL_STATS_TOP_EVENTS_COUNTS, (Object)TOP_K_MAX);
            k = TOP_K_MAX;
        }
        this.k = k;
        this.descMap = new ConcurrentHashMap();
        this.topKEvents = new ConcurrentHashMap();
    }

    public synchronized void addEntry(String eventType, String eventId, long timeTaken) {
        this.lastEventId = eventId;
        DescriptiveStatistics descStatistics = this.descMap.get(eventType);
        if (descStatistics == null) {
            descStatistics = new DescriptiveStatistics();
            descStatistics.addValue((double)timeTaken);
            this.descMap.put(eventType, descStatistics);
        } else {
            descStatistics.addValue((double)timeTaken);
        }
        ListOrderedMap topKEntries = this.topKEvents.get(eventType);
        if (topKEntries == null) {
            topKEntries = new ListOrderedMap();
            topKEntries.put((Object)Long.parseLong(eventId), (Object)timeTaken);
            this.topKEvents.put(eventType, (ListOrderedMap<Long, Long>)topKEntries);
        } else {
            int insertionIndex;
            int index = Collections.binarySearch(new ArrayList(topKEntries.values()), timeTaken, Collections.reverseOrder());
            int n = insertionIndex = index < 0 ? -1 * index - 1 : index;
            if (insertionIndex < this.k && this.k >= 0) {
                topKEntries.put(insertionIndex, (Object)Long.parseLong(eventId), (Object)timeTaken);
            }
            if (topKEntries.size() > this.k) {
                topKEntries.remove(this.k);
            }
        }
    }

    public ConcurrentHashMap<String, DescriptiveStatistics> getDescMap() {
        return this.descMap;
    }

    public ConcurrentHashMap<String, ListOrderedMap<Long, Long>> getTopKEvents() {
        return this.topKEvents;
    }

    public String getLastEventId() {
        return this.lastEventId;
    }

    public int getK() {
        return this.k;
    }

    private String formatDouble(DecimalFormat dFormat, Double d) {
        if (!d.isNaN()) {
            return dFormat.format(d);
        }
        return d.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        DecimalFormat dFormat = new DecimalFormat("#.##");
        dFormat.setRoundingMode(RoundingMode.HALF_UP);
        sb.append("Replication Stats{");
        for (Map.Entry<String, DescriptiveStatistics> event : this.descMap.entrySet()) {
            DescriptiveStatistics statistics = event.getValue();
            sb.append("[[Event Name: ").append(event.getKey()).append("; ");
            sb.append("Total Number: ").append(statistics.getN()).append("; ");
            sb.append("Total Time: ").append(dFormat.format(statistics.getSum())).append("; ");
            sb.append("Mean: ").append(this.formatDouble(dFormat, statistics.getMean())).append("; ");
            sb.append("Median: ").append(this.formatDouble(dFormat, statistics.getPercentile(50.0))).append("; ");
            sb.append("Standard Deviation: ").append(this.formatDouble(dFormat, statistics.getStandardDeviation())).append("; ");
            sb.append("Variance: ").append(this.formatDouble(dFormat, statistics.getVariance())).append("; ");
            sb.append("Kurtosis: ").append(this.formatDouble(dFormat, statistics.getKurtosis())).append("; ");
            sb.append("Skewness: ").append(this.formatDouble(dFormat, statistics.getSkewness())).append("; ");
            sb.append("25th Percentile: ").append(this.formatDouble(dFormat, statistics.getPercentile(25.0))).append("; ");
            sb.append("50th Percentile: ").append(this.formatDouble(dFormat, statistics.getPercentile(50.0))).append("; ");
            sb.append("75th Percentile: ").append(this.formatDouble(dFormat, statistics.getPercentile(75.0))).append("; ");
            sb.append("90th Percentile: ").append(this.formatDouble(dFormat, statistics.getPercentile(90.0))).append("; ");
            sb.append("Top ").append(this.k).append(" EventIds(EventId=Time) ").append(this.topKEvents.get(event.getKey())).append(";]]");
        }
        sb.append("}");
        return sb.toString();
    }
}

