SELECT 'Upgrading MetaStore schema from 2.1.0 to 2.2.0' AS MESSAGE;

-- SOURCE 037-HIVE-14496.mysql.sql;
-- Step 1: Add the column allowing null
ALTER TABLE `TBLS` ADD `IS_REWRITE_ENABLED` bit(1);

 -- Step 2: Replace the null with default value (false)
UPDATE `TBLS` SET `IS_REWRITE_ENABLED` = false;

-- Step 3: Alter the column to disallow null values
ALTER TABLE `TBLS` MODIFY COLUMN `IS_REWRITE_ENABLED` bit(1) NOT NULL DEFAULT 0;

-- SOURCE 038-HIVE-10562.mysql.sql;
-- Step 1: Add the column for format
ALTER TABLE `NOTIFICATION_LOG` ADD `MESSAGE_FORMAT` varchar(16);
-- if MESSAGE_FORMAT is null, then it is the legacy hcat JSONMessageFactory that created this message

-- Step 2 : Change the type of the MESSAGE field from mediumtext to longtext
ALTER TABLE `NOTIFICATION_LOG` MODIFY `MESSAGE` longtext;

-- SOURCE 039-HIVE-12274.mysql.sql;
ALTER TABLE COLUMNS_V2 MODIFY TYPE_NAME MEDIUMTEXT;
ALTER TABLE TABLE_PARAMS MODIFY PARAM_VALUE MEDIUMTEXT;
ALTER TABLE SERDE_PARAMS MODIFY PARAM_VALUE MEDIUMTEXT;
ALTER TABLE SD_PARAMS MODIFY PARAM_VALUE MEDIUMTEXT;

ALTER TABLE TBLS MODIFY TBL_NAME varchar(256) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL;
ALTER TABLE NOTIFICATION_LOG MODIFY TBL_NAME varchar(256) CHARACTER SET latin1 COLLATE latin1_bin;
ALTER TABLE PARTITION_EVENTS MODIFY TBL_NAME varchar(256) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL;
ALTER TABLE TAB_COL_STATS MODIFY TABLE_NAME varchar(256) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL;
ALTER TABLE PART_COL_STATS MODIFY TABLE_NAME varchar(256) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL;
ALTER TABLE COMPLETED_TXN_COMPONENTS MODIFY CTC_TABLE varchar(256) CHARACTER SET latin1 COLLATE latin1_bin;

ALTER TABLE COLUMNS_V2 MODIFY COLUMN_NAME varchar(767) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL;
ALTER TABLE PART_COL_PRIVS MODIFY COLUMN_NAME varchar(767) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL;
ALTER TABLE TBL_COL_PRIVS MODIFY COLUMN_NAME varchar(767) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL;
ALTER TABLE SORT_COLS MODIFY COLUMN_NAME varchar(767) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL;
ALTER TABLE TAB_COL_STATS MODIFY COLUMN_NAME varchar(767) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL;
ALTER TABLE PART_COL_STATS MODIFY COLUMN_NAME varchar(767) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL;

UPDATE VERSION SET SCHEMA_VERSION='2.2.0', VERSION_COMMENT='Hive release version 2.2.0' where VER_ID=1;
SELECT 'Finished upgrading MetaStore schema from 2.1.0 to 2.2.0' AS MESSAGE;

