<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

## [6.0.0](https://github.com/apache/datafusion/tree/6.0.0) (2021-11-13)

[Full Changelog](https://github.com/apache/datafusion/compare/5.0.0...6.0.0)

**Breaking changes:**

- Removed deprecated with_concurrency [\#1200](https://github.com/apache/datafusion/pull/1200) ([rdettai](https://github.com/rdettai))
- File partitioning for ListingTable [\#1141](https://github.com/apache/datafusion/pull/1141) ([rdettai](https://github.com/rdettai))
- Add function volatility to Signature [\#1071](https://github.com/apache/datafusion/pull/1071) [[sql](https://github.com/apache/datafusion/labels/sql)] ([pjmore](https://github.com/pjmore))
- fix: allow duplicate field names in table join, fix output with duplicated names [\#1023](https://github.com/apache/datafusion/pull/1023) ([houqp](https://github.com/houqp))
- Make TableProvider.scan\(\) and PhysicalPlanner::create_physical_plan\(\) async [\#1013](https://github.com/apache/datafusion/pull/1013) ([rdettai](https://github.com/rdettai))
- Reorganize table providers by table format [\#1010](https://github.com/apache/datafusion/pull/1010) ([rdettai](https://github.com/rdettai))
- Make Metrics::labels\(\) public [\#999](https://github.com/apache/datafusion/pull/999) ([alamb](https://github.com/alamb))
- Rename NthValue::{first_value,last_value,nth_value} to satisfy clippy in Rust 1.55 [\#986](https://github.com/apache/datafusion/pull/986) ([alamb](https://github.com/alamb))
- Move CBOs and Statistics to physical plan [\#965](https://github.com/apache/datafusion/pull/965) ([rdettai](https://github.com/rdettai))
- Update to sqlparser v 0.10.0 [\#934](https://github.com/apache/datafusion/pull/934) [[sql](https://github.com/apache/datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- FilePartition and PartitionedFile for scanning flexibility [\#932](https://github.com/apache/datafusion/pull/932) [[sql](https://github.com/apache/datafusion/labels/sql)] ([yjshen](https://github.com/yjshen))
- Improve SQLMetric APIs, port existing metrics [\#908](https://github.com/apache/datafusion/pull/908) ([alamb](https://github.com/alamb))
- Add support for EXPLAIN ANALYZE [\#858](https://github.com/apache/datafusion/pull/858) [[sql](https://github.com/apache/datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Rename concurrency to target_partitions [\#706](https://github.com/apache/datafusion/pull/706) ([andygrove](https://github.com/andygrove))

**Implemented enhancements:**

- Add booleans support to the `CASE` statement [\#1156](https://github.com/apache/datafusion/issues/1156)
- Implement General Purpose Constant Folding with the Expression Evaluator [\#1070](https://github.com/apache/datafusion/issues/1070)
- Mark volatility categories of functions [\#1069](https://github.com/apache/datafusion/issues/1069)
- Add "show" support to DataFrame API [\#937](https://github.com/apache/datafusion/issues/937)
- Add support for TRIM BOTH/LEADING/TRAILING [\#935](https://github.com/apache/datafusion/issues/935)
- Add "baseline" metrics to all built in operators [\#866](https://github.com/apache/datafusion/issues/866)
- Add SQL support for referencing fields in structs [\#119](https://github.com/apache/datafusion/issues/119)
- add filename completer for create table statement [\#1278](https://github.com/apache/datafusion/pull/1278) ([Jimexist](https://github.com/Jimexist))
- Add drop table support [\#1266](https://github.com/apache/datafusion/pull/1266) [[sql](https://github.com/apache/datafusion/labels/sql)] ([viirya](https://github.com/viirya))
- Dataframe supports except and update readme [\#1261](https://github.com/apache/datafusion/pull/1261) ([xudong963](https://github.com/xudong963))
- Implement EXCEPT & EXCEPT DISTINCT [\#1259](https://github.com/apache/datafusion/pull/1259) [[sql](https://github.com/apache/datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Add DataFrame support for `INTERSECT` and update readme [\#1258](https://github.com/apache/datafusion/pull/1258) ([xudong963](https://github.com/xudong963))
- use arrow 6.1.0 [\#1255](https://github.com/apache/datafusion/pull/1255) ([Jimexist](https://github.com/Jimexist))
- fix 1250, add editor support for datafusion cli with validation [\#1251](https://github.com/apache/datafusion/pull/1251) ([Jimexist](https://github.com/Jimexist))
- Add support for `create table as` via MemTable [\#1243](https://github.com/apache/datafusion/pull/1243) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Dandandan](https://github.com/Dandandan))
- Add cli show columns command to describe tables [\#1231](https://github.com/apache/datafusion/pull/1231) ([Jimexist](https://github.com/Jimexist))
- datafusion-cli to add list table command [\#1229](https://github.com/apache/datafusion/pull/1229) ([Jimexist](https://github.com/Jimexist))
- datafusion cli to handle EoF and interrupt signal [\#1225](https://github.com/apache/datafusion/pull/1225) ([Jimexist](https://github.com/Jimexist))
- add \q as quit command and add \? for help [\#1224](https://github.com/apache/datafusion/pull/1224) ([Jimexist](https://github.com/Jimexist))
- Add algebraic simplifications to constant_folding [\#1208](https://github.com/apache/datafusion/pull/1208) ([matthewmturner](https://github.com/matthewmturner))
- Improve GetIndexedFieldExpr adding utf8 key based access for struct v… [\#1204](https://github.com/apache/datafusion/pull/1204) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Igosuki](https://github.com/Igosuki))
- Fix `between` in select query [\#1202](https://github.com/apache/datafusion/pull/1202) [[sql](https://github.com/apache/datafusion/labels/sql)] ([capkurmagati](https://github.com/capkurmagati))
- Move code to fold Stable functions like `now()` from `Simplifier` to `ConstEvaluator` [\#1176](https://github.com/apache/datafusion/pull/1176) ([alamb](https://github.com/alamb))
- DataFrame supports window function [\#1167](https://github.com/apache/datafusion/pull/1167) [[sql](https://github.com/apache/datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- add values list expression [\#1165](https://github.com/apache/datafusion/pull/1165) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Jimexist](https://github.com/Jimexist))
- Add booleans support to the CASE statement [\#1161](https://github.com/apache/datafusion/pull/1161) ([xudong963](https://github.com/xudong963))
- Improve error messages when operations are not supported [\#1158](https://github.com/apache/datafusion/pull/1158) ([alamb](https://github.com/alamb))
- Generic constant expression evaluation [\#1153](https://github.com/apache/datafusion/pull/1153) ([alamb](https://github.com/alamb))
- python `lit` function to support bool and byte vec [\#1152](https://github.com/apache/datafusion/pull/1152) ([Jimexist](https://github.com/Jimexist))
- \[nit\] simplify datafusion optimizer module codes [\#1146](https://github.com/apache/datafusion/pull/1146) ([panarch](https://github.com/panarch))
- Add ScalarValue support for arbitrary list elements [\#1142](https://github.com/apache/datafusion/pull/1142) ([jonmmease](https://github.com/jonmmease))
- Multiple files per partitions for CSV Avro Json [\#1138](https://github.com/apache/datafusion/pull/1138) ([rdettai](https://github.com/rdettai))
- Implement INTERSECT & INTERSECT DISTINCT [\#1135](https://github.com/apache/datafusion/pull/1135) [[sql](https://github.com/apache/datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Simplify file struct abstractions [\#1120](https://github.com/apache/datafusion/pull/1120) ([rdettai](https://github.com/rdettai))
- Implement `is [not] distinct from` [\#1117](https://github.com/apache/datafusion/pull/1117) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Dandandan](https://github.com/Dandandan))
- Clean up spawned task on drop for `RepartitionExec`, `SortPreservingMergeExec`, `WindowAggExec` [\#1112](https://github.com/apache/datafusion/pull/1112) ([crepererum](https://github.com/crepererum))
- add hyperloglog implementation \(`add` and `count`\) [\#1095](https://github.com/apache/datafusion/pull/1095) ([Jimexist](https://github.com/Jimexist))
- Add ScalarValue::Struct variant [\#1091](https://github.com/apache/datafusion/pull/1091) ([jonmmease](https://github.com/jonmmease))
- add digest\(utf8, method\) function and refactor all current hash digest functions [\#1090](https://github.com/apache/datafusion/pull/1090) ([Jimexist](https://github.com/Jimexist))
- \[crypto\] add `blake3` algorithm to `digest` function [\#1086](https://github.com/apache/datafusion/pull/1086) ([Jimexist](https://github.com/Jimexist))
- \[crypto\] add blake2b and blake2s functions [\#1081](https://github.com/apache/datafusion/pull/1081) ([Jimexist](https://github.com/Jimexist))
- \[nit\] make schema qualifier error message in field lookup more readable [\#1079](https://github.com/apache/datafusion/pull/1079) ([Jimexist](https://github.com/Jimexist))
- \[window function\] add `percent_rank` window function [\#1077](https://github.com/apache/datafusion/pull/1077) ([Jimexist](https://github.com/Jimexist))
- \[window function\] add `cume_dist` implementation [\#1076](https://github.com/apache/datafusion/pull/1076) ([Jimexist](https://github.com/Jimexist))
- Add a LogicalPlanBuilder::schema\(\) function [\#1075](https://github.com/apache/datafusion/pull/1075) ([alamb](https://github.com/alamb))
- Add support for UNION \[DISTINCT\] sql [\#1068](https://github.com/apache/datafusion/pull/1068) [[sql](https://github.com/apache/datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- fix: fix joins on Float32/Float64 columns bug [\#1054](https://github.com/apache/datafusion/pull/1054) ([francis-du](https://github.com/francis-du))
- Update sqlparser-rs to 0.11 [\#1052](https://github.com/apache/datafusion/pull/1052) [[sql](https://github.com/apache/datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Support querying CSV files without providing the schema [\#1050](https://github.com/apache/datafusion/pull/1050) [[sql](https://github.com/apache/datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- remove hard coded partition count in ballista logicalplan deserialization [\#1044](https://github.com/apache/datafusion/pull/1044) ([xudong963](https://github.com/xudong963))
- feat: add lit_timestamp_nanosecond [\#1030](https://github.com/apache/datafusion/pull/1030) ([NGA-TRAN](https://github.com/NGA-TRAN))
- Ignore metadata on schema merge [\#1024](https://github.com/apache/datafusion/pull/1024) ([Smurphy000](https://github.com/Smurphy000))
- add ExecutionConfig.with_optimizer_rules [\#1022](https://github.com/apache/datafusion/pull/1022) ([seddonm1](https://github.com/seddonm1))
- Add baseline execution stats to `WindowAggExec` and `UnionExec`, and fixup `CoalescePartitionsExec` [\#1018](https://github.com/apache/datafusion/pull/1018) ([alamb](https://github.com/alamb))
- Derive PartialOrd for Expr [\#1015](https://github.com/apache/datafusion/pull/1015) ([alamb](https://github.com/alamb))
- Indexed field access for List [\#1006](https://github.com/apache/datafusion/pull/1006) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Igosuki](https://github.com/Igosuki))
- Add metrics for Limit and Projection, and CoalesceBatches [\#1004](https://github.com/apache/datafusion/pull/1004) ([alamb](https://github.com/alamb))
- Update DataFusion to arrow 6.0 [\#984](https://github.com/apache/datafusion/pull/984) ([alamb](https://github.com/alamb))
- Implement Display for Expr, improve operator display [\#971](https://github.com/apache/datafusion/pull/971) [[sql](https://github.com/apache/datafusion/labels/sql)] ([matthewmturner](https://github.com/matthewmturner))
- Add metrics for FilterExec [\#960](https://github.com/apache/datafusion/pull/960) ([alamb](https://github.com/alamb))
- Change compound column field name rules [\#952](https://github.com/apache/datafusion/pull/952) ([waynexia](https://github.com/waynexia))
- ObjectStore API to read from remote storage systems [\#950](https://github.com/apache/datafusion/pull/950) ([yjshen](https://github.com/yjshen))
- Add baseline metrics to `SortPreservingMergeExec` [\#948](https://github.com/apache/datafusion/pull/948) ([alamb](https://github.com/alamb))
- Add support for TRIM LEADING/TRAILING/BOTH syntax [\#947](https://github.com/apache/datafusion/pull/947) [[sql](https://github.com/apache/datafusion/labels/sql)] ([adsharma](https://github.com/adsharma))
- fixes \#933 replace placeholder fmt_as fr ExecutionPlan impls [\#939](https://github.com/apache/datafusion/pull/939) ([tiphaineruy](https://github.com/tiphaineruy))
- Add metrics for SortExect + HashAggregateExec [\#938](https://github.com/apache/datafusion/pull/938) ([alamb](https://github.com/alamb))
- Add some additional asserts in `utils::from_plan` [\#930](https://github.com/apache/datafusion/pull/930) ([alamb](https://github.com/alamb))
- Avro Table Provider [\#910](https://github.com/apache/datafusion/pull/910) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Igosuki](https://github.com/Igosuki))
- Add BaselineMetrics, Timestamp metrics, add for `CoalescePartitionsExec`, rename output_time -\> elapsed_compute [\#909](https://github.com/apache/datafusion/pull/909) ([alamb](https://github.com/alamb))
- add cross join support to ballista [\#891](https://github.com/apache/datafusion/pull/891) ([houqp](https://github.com/houqp))
- Add Ballista support to DataFusion CLI [\#889](https://github.com/apache/datafusion/pull/889) ([andygrove](https://github.com/andygrove))
- support like on DictionaryArray [\#876](https://github.com/apache/datafusion/pull/876) ([b41sh](https://github.com/b41sh))
- Register table based on known schema without file IO [\#872](https://github.com/apache/datafusion/pull/872) ([Dandandan](https://github.com/Dandandan))
- Add support for PostgreSQL regex match [\#870](https://github.com/apache/datafusion/pull/870) [[sql](https://github.com/apache/datafusion/labels/sql)] ([b41sh](https://github.com/b41sh))
- Include planning time in datafusion-cli printing [\#860](https://github.com/apache/datafusion/pull/860) ([Dandandan](https://github.com/Dandandan))
- Implement basic common subexpression eliminate optimization [\#792](https://github.com/apache/datafusion/pull/792) ([waynexia](https://github.com/waynexia))
- Impl `ops::Not` for `expr` [\#763](https://github.com/apache/datafusion/pull/763) ([Jimexist](https://github.com/Jimexist))

**Fixed bugs:**

- Can not use `between` in the select list: [\#1196](https://github.com/apache/datafusion/issues/1196)
- ORDER BY does not work with literals: Sort operation is not applicable to scalar value 'foo' [\#1195](https://github.com/apache/datafusion/issues/1195)
- window functions with NULL literals in `partition by` and `order by` do not work: Internal\("Sort operation is not applicable to scalar value NULL"\) [\#1194](https://github.com/apache/datafusion/issues/1194)
- Operation name not included in internal errors -- Internal\("Data type Boolean not supported for binary operation on dyn arrays"\) [\#1157](https://github.com/apache/datafusion/issues/1157)
- Physical plan explain UNION query says "ExecutionPlan\(PlaceHolder\)" [\#933](https://github.com/apache/datafusion/issues/933)
- Can not use LIKE on DictionaryArray encoded strings [\#815](https://github.com/apache/datafusion/issues/815)
- physical_plan::repartition::tests::repartition_with_dropping_output_stream failing locally [\#614](https://github.com/apache/datafusion/issues/614)
- Fix some `BuiltinScalarFunction` panics with zero arguments [\#1249](https://github.com/apache/datafusion/pull/1249) ([capkurmagati](https://github.com/capkurmagati))
- fix: not do boolean folding on NULL and/or expr [\#1245](https://github.com/apache/datafusion/pull/1245) ([NGA-TRAN](https://github.com/NGA-TRAN))
- ignore case of `with header row` in sql when creating external table [\#1237](https://github.com/apache/datafusion/pull/1237) [[sql](https://github.com/apache/datafusion/labels/sql)] ([lichuan6](https://github.com/lichuan6))
- fix: Min/Max aggregation data type should not be dictionary [\#1235](https://github.com/apache/datafusion/pull/1235) ([NGA-TRAN](https://github.com/NGA-TRAN))
- Fix build with `--no-default-features` [\#1219](https://github.com/apache/datafusion/pull/1219) ([alamb](https://github.com/alamb))
- Prevent "future cannot be sent between threads safely" compilation error [\#1155](https://github.com/apache/datafusion/pull/1155) ([jonmmease](https://github.com/jonmmease))
- Clean up spawned task on drop for `AnalyzeExec`, `CoalescePartitionsExec`, `HashAggregateExec` [\#1121](https://github.com/apache/datafusion/pull/1121) ([crepererum](https://github.com/crepererum))
- Clean up spawned task on `SortStream` drop [\#1105](https://github.com/apache/datafusion/pull/1105) ([crepererum](https://github.com/crepererum))
- fix UNION ALL bug: thread 'main' panicked at 'index out of bounds: the len is 1 but the index is 1', ./src/datatypes/schema.rs:165:10 [\#1088](https://github.com/apache/datafusion/pull/1088) ([xudong963](https://github.com/xudong963))
- python: fix generated table name in dataframe creation [\#1078](https://github.com/apache/datafusion/pull/1078) ([houqp](https://github.com/houqp))
- fix subquery alias [\#1067](https://github.com/apache/datafusion/pull/1067) [[sql](https://github.com/apache/datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- fix pattern handling in regexp_match function [\#1065](https://github.com/apache/datafusion/pull/1065) ([houqp](https://github.com/houqp))
- fix: joins on Timestamp columns [\#1055](https://github.com/apache/datafusion/pull/1055) ([francis-du](https://github.com/francis-du))
- Fix metric name typo [\#943](https://github.com/apache/datafusion/pull/943) ([alamb](https://github.com/alamb))
- EXPLAIN ANALYZE should run all Optimizer passes [\#929](https://github.com/apache/datafusion/pull/929) ([alamb](https://github.com/alamb))

**Documentation updates:**

- update docs to fix DataFusion User Guide link [\#1238](https://github.com/apache/datafusion/pull/1238) ([jiangzhx](https://github.com/jiangzhx))
- \[docs\] datafusion cli run via homebrew [\#1198](https://github.com/apache/datafusion/pull/1198) ([Jimexist](https://github.com/Jimexist))
- add support for unary and binary values in values list, update docs [\#1172](https://github.com/apache/datafusion/pull/1172) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Jimexist](https://github.com/Jimexist))
- Add additional docstring comments to `from_plan` [\#1168](https://github.com/apache/datafusion/pull/1168) ([alamb](https://github.com/alamb))
- \[nit\] fix document issue for `approx_distinct` [\#1110](https://github.com/apache/datafusion/pull/1110) ([Jimexist](https://github.com/Jimexist))
- implement `approx_distinct` function using HyperLogLog [\#1087](https://github.com/apache/datafusion/pull/1087) ([Jimexist](https://github.com/Jimexist))
- Remove unused `use` statements from examples [\#1032](https://github.com/apache/datafusion/pull/1032) ([alamb](https://github.com/alamb))
- consolidate datafusion docs with sphinx [\#993](https://github.com/apache/datafusion/pull/993) ([houqp](https://github.com/houqp))
- Updated user-guide library docs with optimized config [\#976](https://github.com/apache/datafusion/pull/976) ([matthewmturner](https://github.com/matthewmturner))
- Improve User Guide [\#954](https://github.com/apache/datafusion/pull/954) ([andygrove](https://github.com/andygrove))
- \[MINOR\] Fix typos in doc comments [\#945](https://github.com/apache/datafusion/pull/945) ([alamb](https://github.com/alamb))
- \[DataFusion\] - Add show and show_limit function for DataFrame [\#923](https://github.com/apache/datafusion/pull/923) ([francis-du](https://github.com/francis-du))
- Typo fix in DataFusion crate documentation [\#914](https://github.com/apache/datafusion/pull/914) ([antoinewdg](https://github.com/antoinewdg))

**Performance improvements:**

- Improve avro reader performance by avoiding some cloning on avro_rs::Value [\#1206](https://github.com/apache/datafusion/pull/1206) ([Igosuki](https://github.com/Igosuki))
- optimize build profile for datafusion python binding, cli and ballista [\#1137](https://github.com/apache/datafusion/pull/1137) ([houqp](https://github.com/houqp))
- Avoid stack overflow by reducing stack usage of `BinaryExpr::evaluate` in debug builds [\#1047](https://github.com/apache/datafusion/pull/1047) ([alamb](https://github.com/alamb))
- Add ScalarValue::eq_array optimized comparison function [\#844](https://github.com/apache/datafusion/pull/844) ([alamb](https://github.com/alamb))
- Rework GroupByHash to for faster performance and support grouping by nulls [\#808](https://github.com/apache/datafusion/pull/808) ([alamb](https://github.com/alamb))

**Closed issues:**

- InList expr with NULL literals do not work [\#1190](https://github.com/apache/datafusion/issues/1190)
- update the homepage README to include values, `approx_distinct`, etc. [\#1171](https://github.com/apache/datafusion/issues/1171)
- \[Python\]: Inconsistencies with Python package name [\#1011](https://github.com/apache/datafusion/issues/1011)
- Wanting to contribute to project where to start? [\#983](https://github.com/apache/datafusion/issues/983)
- delete redundant code [\#973](https://github.com/apache/datafusion/issues/973)
- How to build DataFusion python wheel [\#853](https://github.com/apache/datafusion/issues/853)
- Add support for partition pruning [\#204](https://github.com/apache/datafusion/issues/204)
- \[Datafusion\] Support joins on TimestampMillisecond columns [\#187](https://github.com/apache/datafusion/issues/187)
- TPC-H Query 21 [\#173](https://github.com/apache/datafusion/issues/173)
- TPC-H Query 13 [\#164](https://github.com/apache/datafusion/issues/164)
- TPC-H Query 8 [\#162](https://github.com/apache/datafusion/issues/162)
- implement split_part\(string, delimiter, position\) [\#157](https://github.com/apache/datafusion/issues/157)
- Join Statement: Schema contains duplicate unqualified field name [\#155](https://github.com/apache/datafusion/issues/155)
- ParquetTable should avoid scanning all files twice [\#136](https://github.com/apache/datafusion/issues/136)
- Add support for reading partitioned Parquet files [\#133](https://github.com/apache/datafusion/issues/133)
- Add support for Parquet schema merging [\#132](https://github.com/apache/datafusion/issues/132)
- Catalog abstraction [\#126](https://github.com/apache/datafusion/issues/126)
- Optimizer rules should work with qualified column names [\#125](https://github.com/apache/datafusion/issues/125)
- Add optional qualifier to Expr::Column [\#121](https://github.com/apache/datafusion/issues/121)
- Implement modulus expression [\#99](https://github.com/apache/datafusion/issues/99)
- \[Rust\] Add constant folding to expressions during logically planning [\#98](https://github.com/apache/datafusion/issues/98)
- \[Rust\] Implement pretty print for physical query plan [\#93](https://github.com/apache/datafusion/issues/93)
- Can not group by boolean columns \(add boolean to valid keys of groupBy\) [\#91](https://github.com/apache/datafusion/issues/91)
- improve performance of building literal arrays [\#90](https://github.com/apache/datafusion/issues/90)
- \[rust\]\[datafusion\] optimize count\(\*\) queries on parquet sources [\#89](https://github.com/apache/datafusion/issues/89)
- Produce a design for a metrics framework [\#21](https://github.com/apache/datafusion/issues/21)

**Merged pull requests:**

- Add timezome string to stablize test [\#1265](https://github.com/apache/datafusion/pull/1265) ([viirya](https://github.com/viirya))
- numerical_coercion pattern match optimize [\#1256](https://github.com/apache/datafusion/pull/1256) ([Jimexist](https://github.com/Jimexist))
- fix and update window function sql tests [\#1059](https://github.com/apache/datafusion/pull/1059) ([Jimexist](https://github.com/Jimexist))
- reduce ScalarValue from trait boilerplate with macro [\#989](https://github.com/apache/datafusion/pull/989) ([houqp](https://github.com/houqp))
