/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import com.carrotsearch.hppc.LongStack;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.UnfilteredValidation;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.AbstractSSTableIterator;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.bti.BtiTableReader;
import org.apache.cassandra.io.sstable.format.bti.RowIndexReader;
import org.apache.cassandra.io.sstable.format.bti.RowIndexReverseIterator;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;

class SSTableReversedIterator
extends AbstractSSTableIterator<TrieIndexEntry> {
    private int slice;

    public SSTableReversedIterator(BtiTableReader sstable, FileDataInput file, DecoratedKey key, TrieIndexEntry indexEntry, Slices slices, ColumnFilter columns, FileHandle ifile) {
        super(sstable, file, key, indexEntry, slices, columns, ifile);
    }

    @Override
    protected AbstractSSTableIterator.Reader createReaderInternal(TrieIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile, Version version) {
        if (indexEntry.isIndexed()) {
            return new ReverseIndexedReader(indexEntry, file, shouldCloseFile);
        }
        return new ReverseReader(file, shouldCloseFile);
    }

    @Override
    public boolean isReverseOrder() {
        return true;
    }

    @Override
    protected int nextSliceIndex() {
        int next = this.slice++;
        return this.slices.size() - (next + 1);
    }

    @Override
    protected boolean hasMoreSlices() {
        return this.slice < this.slices.size();
    }

    private class ReverseIndexedReader
    extends ReverseReader {
        private RowIndexReverseIterator indexReader;
        private final TrieIndexEntry indexEntry;
        private final long basePosition;
        private Slice currentSlice;
        private long currentBlockStart;

        public ReverseIndexedReader(AbstractRowIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile) {
            super(file, shouldCloseFile);
            this.basePosition = indexEntry.position;
            this.indexEntry = (TrieIndexEntry)indexEntry;
        }

        @Override
        public void close() throws IOException {
            if (this.indexReader != null) {
                this.indexReader.close();
            }
            super.close();
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            this.currentSlice = slice;
            ClusteringComparator comparator = ((SSTableReversedIterator)SSTableReversedIterator.this).metadata.comparator;
            if (this.indexReader != null) {
                this.indexReader.close();
            }
            this.indexReader = new RowIndexReverseIterator(SSTableReversedIterator.this.ifile, this.indexEntry, comparator.asByteComparable(slice.end()), ((SSTableReversedIterator)SSTableReversedIterator.this).sstable.descriptor.version);
            this.gotoBlock(this.indexReader.nextIndexInfo(), true, Long.MAX_VALUE);
        }

        boolean gotoBlock(RowIndexReader.IndexInfo indexInfo, boolean filterEnd, long blockEnd) throws IOException {
            this.blockOpenMarker = null;
            this.blockCloseMarker = null;
            this.rowOffsets.clear();
            if (indexInfo == null) {
                return false;
            }
            this.currentBlockStart = this.basePosition + indexInfo.offset;
            this.openMarker = indexInfo.openDeletion;
            this.seekToPosition(this.currentBlockStart);
            this.fillOffsets(this.currentSlice, true, filterEnd, blockEnd);
            return !this.rowOffsets.isEmpty();
        }

        @Override
        protected boolean advanceIndexBlock() throws IOException {
            return this.gotoBlock(this.indexReader.nextIndexInfo(), false, this.currentBlockStart);
        }
    }

    private class ReverseReader
    extends AbstractSSTableIterator.AbstractReader {
        final LongStack rowOffsets;
        RangeTombstoneMarker blockOpenMarker;
        RangeTombstoneMarker blockCloseMarker;
        private Unfiltered next;
        private boolean foundLessThan;
        private long startPos;

        private ReverseReader(FileDataInput file, boolean shouldCloseFile) {
            super(file, shouldCloseFile);
            this.rowOffsets = new LongStack();
            this.next = null;
            this.startPos = -1L;
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            if (this.startPos == -1L) {
                this.startPos = this.file.getFilePointer();
            } else {
                this.seekToPosition(this.startPos);
            }
            this.fillOffsets(slice, true, true, Long.MAX_VALUE);
        }

        @Override
        protected boolean hasNextInternal() throws IOException {
            if (this.next != null) {
                return true;
            }
            this.next = this.computeNext();
            return this.next != null;
        }

        @Override
        protected Unfiltered nextInternal() throws IOException {
            if (!this.hasNextInternal()) {
                throw new NoSuchElementException();
            }
            Unfiltered toReturn = this.next;
            this.next = null;
            return toReturn;
        }

        private Unfiltered computeNext() throws IOException {
            Unfiltered toReturn;
            do {
                if (this.blockCloseMarker != null) {
                    toReturn = this.blockCloseMarker;
                    this.blockCloseMarker = null;
                    return toReturn;
                }
                while (!this.rowOffsets.isEmpty()) {
                    this.seekToPosition(this.rowOffsets.pop());
                    boolean hasNext = this.deserializer.hasNext();
                    assert (hasNext) : "Data file changed after offset collection pass";
                    toReturn = this.deserializer.readNext();
                    UnfilteredValidation.maybeValidateUnfiltered(toReturn, SSTableReversedIterator.this.metadata(), SSTableReversedIterator.this.key, SSTableReversedIterator.this.sstable);
                    if (toReturn.isEmpty()) continue;
                    return toReturn;
                }
            } while (!this.foundLessThan && this.advanceIndexBlock());
            if (this.blockOpenMarker != null) {
                toReturn = this.blockOpenMarker;
                this.blockOpenMarker = null;
                return toReturn;
            }
            return null;
        }

        protected boolean advanceIndexBlock() throws IOException {
            return false;
        }

        void fillOffsets(Slice slice, boolean filterStart, boolean filterEnd, long stopPosition) throws IOException {
            filterStart &= !slice.start().equals(ClusteringBound.BOTTOM);
            filterEnd &= !slice.end().equals(ClusteringBound.TOP);
            ClusteringBound<?> start = slice.start();
            long currentPosition = this.file.getFilePointer();
            this.foundLessThan = false;
            if (filterStart) {
                while (currentPosition < stopPosition && this.deserializer.hasNext() && this.deserializer.compareNextTo(start) <= 0) {
                    if (this.deserializer.nextIsRow()) {
                        this.deserializer.skipNext();
                    } else {
                        this.updateOpenMarker((RangeTombstoneMarker)this.deserializer.readNext());
                    }
                    currentPosition = this.file.getFilePointer();
                    this.foundLessThan = true;
                }
            }
            if (this.openMarker != null) {
                this.blockOpenMarker = new RangeTombstoneBoundMarker(start, this.openMarker);
            }
            while (currentPosition < stopPosition && this.deserializer.hasNext() && (!filterEnd || this.deserializer.compareNextTo(slice.end()) < 0)) {
                this.rowOffsets.push(currentPosition);
                if (this.deserializer.nextIsRow()) {
                    this.deserializer.skipNext();
                } else {
                    this.updateOpenMarker((RangeTombstoneMarker)this.deserializer.readNext());
                }
                currentPosition = this.file.getFilePointer();
            }
            if (this.openMarker != null && filterEnd) {
                this.blockCloseMarker = new RangeTombstoneBoundMarker(slice.end(), this.openMarker);
                this.openMarker = null;
            }
        }
    }
}

