/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.index.Index;

public class SingletonIndexQueryPlan
implements Index.QueryPlan {
    private final Index index;
    private final Set<Index> indexes;
    private final RowFilter postIndexFilter;

    protected SingletonIndexQueryPlan(Index index, RowFilter postIndexFilter) {
        this.index = index;
        this.indexes = Collections.singleton(index);
        this.postIndexFilter = postIndexFilter;
    }

    @Nullable
    protected static SingletonIndexQueryPlan create(Index index, RowFilter rowFilter) {
        for (RowFilter.Expression e : rowFilter.getExpressions()) {
            if (!index.supportsExpression(e.column(), e.operator())) continue;
            return new SingletonIndexQueryPlan(index, index.getPostIndexQueryFilter(rowFilter));
        }
        return null;
    }

    @Override
    public Set<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    @Nonnull
    public Index getFirst() {
        return this.index;
    }

    @Override
    public long getEstimatedResultRows() {
        return this.index.getEstimatedResultRows();
    }

    @Override
    public Index.Searcher searcherFor(ReadCommand command) {
        return this.index.searcherFor(command);
    }

    @Override
    public RowFilter postIndexQueryFilter() {
        return this.postIndexFilter;
    }
}

