/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.MemoryUtil;
import org.apache.cassandra.utils.memory.NativeAllocator;
import org.apache.cassandra.utils.memory.NativeEndianMemoryUtil;

public class NativeDecoratedKey
extends DecoratedKey {
    final long peer;

    public NativeDecoratedKey(Token token, NativeAllocator allocator, OpOrder.Group writeOp, ByteBuffer key) {
        super(token);
        assert (key != null);
        assert (key.order() == ByteOrder.BIG_ENDIAN);
        int size = key.remaining();
        this.peer = allocator.allocate(4 + size, writeOp);
        NativeEndianMemoryUtil.setInt(this.peer, size);
        MemoryUtil.setBytes(this.peer + 4L, key);
    }

    public NativeDecoratedKey(Token token, NativeAllocator allocator, OpOrder.Group writeOp, byte[] keyBytes) {
        super(token);
        assert (keyBytes != null);
        int size = keyBytes.length;
        this.peer = allocator.allocate(4 + size, writeOp);
        NativeEndianMemoryUtil.setInt(this.peer, size);
        MemoryUtil.setBytes(this.peer + 4L, keyBytes, 0, size);
    }

    int length() {
        return NativeEndianMemoryUtil.getInt(this.peer);
    }

    long address() {
        return this.peer + 4L;
    }

    @Override
    public ByteBuffer getKey() {
        return MemoryUtil.getByteBuffer(this.address(), this.length(), ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int getKeyLength() {
        return NativeEndianMemoryUtil.getInt(this.peer);
    }

    @Override
    protected ByteSource keyComparableBytes(ByteComparable.Version version) {
        return ByteSource.ofMemory(this.address(), this.length(), version);
    }
}

