/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AccessibleByteArrayOutputStream;
import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import com.amazon.corretto.crypto.provider.Utils;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

final class AesKeyWrapPaddingSpi
extends CipherSpi {
    private static final int BLOCK_SIZE = 16;
    private final AmazonCorrettoCryptoProvider provider;
    private SecretKey jceKey;
    private byte[] keyBytes;
    private int opmode = -1;
    private final AccessibleByteArrayOutputStream buffer;

    AesKeyWrapPaddingSpi(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
        Loader.checkNativeLibraryAvailability();
        this.provider = amazonCorrettoCryptoProvider;
        this.buffer = new AccessibleByteArrayOutputStream();
    }

    private static native int wrapKey(byte[] var0, byte[] var1, int var2, byte[] var3, int var4);

    private static native int unwrapKey(byte[] var0, byte[] var1, int var2, byte[] var3, int var4);

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string != null && !"KWP".equals(string)) {
            throw new NoSuchAlgorithmException(string + " cannot be used");
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string != null && !"NoPadding".equalsIgnoreCase(string)) {
            throw new NoSuchPaddingException("Unsupported padding " + string);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Can't encode key to obtain length");
        }
        int n = key.getEncoded().length;
        Arrays.fill(byArray, (byte)0);
        return Math.multiplyExact(n, 8);
    }

    @Override
    protected int engineGetOutputSize(int n) {
        int n2 = Math.addExact(this.buffer.size(), n);
        switch (this.opmode) {
            case 1: 
            case 3: {
                return AesKeyWrapPaddingSpi.getWrappedLen(n2);
            }
        }
        return AesKeyWrapPaddingSpi.estimateUnwrappedLen(n2);
    }

    private static int getWrappedLen(int n) {
        int n2 = n % 8 == 0 ? 0 : 8 - n % 8;
        return Math.addExact(Math.addExact(n, n2), 8);
    }

    private static int estimateUnwrappedLen(int n) {
        if (n < 16) {
            return 8;
        }
        return Math.subtractExact(n, 8);
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.implInit(n, key);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException {
        this.implInit(n, key);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        this.implInit(n, key);
    }

    private void implInit(int n, Key key) throws InvalidKeyException {
        if (n != 4 && n != 3 && n != 1 && n != 2) {
            throw new UnsupportedOperationException("Unsupported mode");
        }
        if (key == null) {
            throw new InvalidKeyException("Null key");
        }
        if (key != this.jceKey) {
            if (!(key instanceof SecretKey)) {
                throw new InvalidKeyException("Need a SecretKey");
            }
            if (!"RAW".equalsIgnoreCase(key.getFormat())) {
                throw new InvalidKeyException("Need a raw format key");
            }
            if (!"AES".equalsIgnoreCase(key.getAlgorithm())) {
                throw new InvalidKeyException("Expected an AES key");
            }
            if (this.keyBytes != null) {
                Arrays.fill(this.keyBytes, (byte)0);
                this.keyBytes = null;
            }
            this.keyBytes = key.getEncoded();
            if (this.keyBytes == null) {
                throw new InvalidKeyException("Key doesn't support encoding");
            }
            this.jceKey = (SecretKey)key;
        }
        this.opmode = n;
        this.buffer.reset();
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.opmode != 1 && this.opmode != 2) {
            throw new IllegalStateException("Cipher not initialized for update");
        }
        this.implUpdate(byArray, n, n2);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (this.opmode != 1 && this.opmode != 2) {
            throw new IllegalStateException("Cipher not initialized for update");
        }
        this.implUpdate(byArray, n, n2);
        return 0;
    }

    private void implUpdate(byte[] byArray, int n, int n2) {
        if (byArray != null && byArray.length > 0 && Math.addExact(n, n2) <= byArray.length) {
            this.buffer.write(byArray, n, n2);
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) {
        if (this.opmode != 1 && this.opmode != 2) {
            throw new IllegalStateException("Cipher not initialized for finalization");
        }
        return this.implDoFinal(byArray, n, n2);
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (this.opmode != 1 && this.opmode != 2) {
            throw new IllegalStateException("Cipher not initialized for finalization");
        }
        int n4 = this.engineGetOutputSize(n2);
        if (byArray2.length - n3 < n4) {
            throw new ShortBufferException("Output buffer needs size of at least " + n4);
        }
        return this.implDoFinal(byArray, n, n2, byArray2, n3);
    }

    private byte[] implDoFinal(byte[] byArray, int n, int n2) {
        int n3 = this.engineGetOutputSize(n2);
        byte[] byArray2 = new byte[n3];
        int n4 = this.implDoFinal(byArray, n, n2, byArray2, 0);
        if (n4 < n3) {
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            Arrays.fill(byArray2, (byte)0);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int implDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.implUpdate(byArray, n, n2);
        try {
            switch (this.opmode) {
                case 1: 
                case 3: {
                    int n4 = AesKeyWrapPaddingSpi.wrapKey(this.keyBytes, this.buffer.getDataBuffer(), this.buffer.size(), byArray2, n3);
                    return n4;
                }
                case 2: 
                case 4: {
                    int n4 = AesKeyWrapPaddingSpi.unwrapKey(this.keyBytes, this.buffer.getDataBuffer(), this.buffer.size(), byArray2, n3);
                    return n4;
                }
                default: {
                    throw new IllegalStateException("Cipher not initialized for finalization");
                }
            }
        }
        finally {
            this.buffer.reset();
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.opmode != 3) {
            throw new IllegalStateException("Cipher must be init'd in WRAP_MODE");
        }
        byte[] byArray = null;
        try {
            byArray = Utils.encodeForWrapping(this.provider, key);
            byte[] byArray2 = this.implDoFinal(byArray, 0, byArray.length);
            return byArray2;
        }
        catch (RuntimeCryptoException runtimeCryptoException) {
            throw new InvalidKeyException("Wrapping failed", runtimeCryptoException);
        }
        finally {
            if (byArray != null) {
                Arrays.fill(byArray, (byte)0);
            }
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.opmode != 4) {
            throw new IllegalStateException("Cipher must be init'd in UNWRAP_MODE");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = this.implDoFinal(byArray, 0, byArray.length);
            Key key = Utils.buildUnwrappedKey(this.provider, byArray2, string, n);
            return key;
        }
        catch (RuntimeCryptoException | InvalidKeySpecException exception) {
            throw new InvalidKeyException("Unwrapping failed", exception);
        }
        finally {
            if (byArray2 != null) {
                Arrays.fill(byArray2, (byte)0);
            }
        }
    }

    static {
        Loader.load();
    }
}

