/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.AsymmetricRemoteSyncTask;
import org.apache.cassandra.repair.CompletableRemoteSyncTask;
import org.apache.cassandra.repair.LocalSyncTask;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.repair.RepairResult;
import org.apache.cassandra.repair.RepairSession;
import org.apache.cassandra.repair.SnapshotTask;
import org.apache.cassandra.repair.SymmetricRemoteSyncTask;
import org.apache.cassandra.repair.SyncStat;
import org.apache.cassandra.repair.SyncTask;
import org.apache.cassandra.repair.SystemDistributedKeyspace;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.ValidationTask;
import org.apache.cassandra.repair.asymmetric.DifferenceHolder;
import org.apache.cassandra.repair.asymmetric.HostDifferences;
import org.apache.cassandra.repair.asymmetric.PreferedNodeFilter;
import org.apache.cassandra.repair.asymmetric.ReduceHelper;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTrees;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairJob
extends AbstractFuture<RepairResult>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RepairJob.class);
    private final RepairSession session;
    private final RepairJobDesc desc;
    private final RepairParallelism parallelismDegree;
    private final ListeningExecutorService taskExecutor;
    private final List<SyncTask> syncTasks = new CopyOnWriteArrayList<SyncTask>();

    public RepairJob(RepairSession session, String columnFamily) {
        this.session = session;
        this.desc = new RepairJobDesc(session.parentRepairSession, session.getId(), session.keyspace, columnFamily, session.commonRange.ranges);
        this.taskExecutor = session.taskExecutor;
        this.parallelismDegree = session.parallelismDegree;
    }

    public int getNowInSeconds() {
        int nowInSeconds = FBUtilities.nowInSeconds();
        if (this.session.previewKind == PreviewKind.REPAIRED) {
            return nowInSeconds + DatabaseDescriptor.getValidationPreviewPurgeHeadStartInSec();
        }
        return nowInSeconds;
    }

    @Override
    public void run() {
        ListenableFuture allSnapshotTasks;
        Keyspace ks = Keyspace.open(this.desc.keyspace);
        final ColumnFamilyStore cfs = ks.getColumnFamilyStore(this.desc.columnFamily);
        cfs.metric.repairsStarted.inc();
        ArrayList<InetAddressAndPort> allEndpoints = new ArrayList<InetAddressAndPort>((Collection<InetAddressAndPort>)this.session.commonRange.endpoints);
        allEndpoints.add(FBUtilities.getBroadcastAddressAndPort());
        if (this.parallelismDegree != RepairParallelism.PARALLEL) {
            if (this.session.isIncremental) {
                allSnapshotTasks = Futures.immediateFuture(allEndpoints);
            } else {
                ArrayList<SnapshotTask> snapshotTasks = new ArrayList<SnapshotTask>(allEndpoints.size());
                for (InetAddressAndPort endpoint : allEndpoints) {
                    SnapshotTask snapshotTask = new SnapshotTask(this.desc, endpoint);
                    snapshotTasks.add(snapshotTask);
                    this.taskExecutor.execute((Runnable)snapshotTask);
                }
                allSnapshotTasks = Futures.allAsList(snapshotTasks);
            }
        } else {
            allSnapshotTasks = null;
        }
        ListenableFuture syncResults = Futures.transformAsync(this.session.validationScheduler.schedule(() -> this.createSyncTasks((ListenableFuture<List<InetAddressAndPort>>)allSnapshotTasks, allEndpoints), (Executor)this.taskExecutor), this::executeTasks, (Executor)this.taskExecutor);
        Futures.addCallback((ListenableFuture)syncResults, (FutureCallback)new FutureCallback<List<SyncStat>>(){

            public void onSuccess(List<SyncStat> stats) {
                if (!((RepairJob)RepairJob.this).session.previewKind.isPreview()) {
                    logger.info("{} {}.{} is fully synced", new Object[]{((RepairJob)RepairJob.this).session.previewKind.logPrefix(RepairJob.this.session.getId()), ((RepairJob)RepairJob.this).desc.keyspace, ((RepairJob)RepairJob.this).desc.columnFamily});
                    SystemDistributedKeyspace.successfulRepairJob(RepairJob.this.session.getId(), ((RepairJob)RepairJob.this).desc.keyspace, ((RepairJob)RepairJob.this).desc.columnFamily);
                }
                cfs.metric.repairsCompleted.inc();
                RepairJob.this.set(new RepairResult(RepairJob.this.desc, stats));
            }

            public void onFailure(Throwable t) {
                RepairJob.this.syncTasks.forEach(SyncTask::abort);
                if (!((RepairJob)RepairJob.this).session.previewKind.isPreview()) {
                    logger.warn("{} {}.{} sync failed", new Object[]{((RepairJob)RepairJob.this).session.previewKind.logPrefix(RepairJob.this.session.getId()), ((RepairJob)RepairJob.this).desc.keyspace, ((RepairJob)RepairJob.this).desc.columnFamily});
                    SystemDistributedKeyspace.failedRepairJob(RepairJob.this.session.getId(), ((RepairJob)RepairJob.this).desc.keyspace, ((RepairJob)RepairJob.this).desc.columnFamily, t);
                }
                cfs.metric.repairsCompleted.inc();
                RepairJob.this.setException(t);
            }
        }, (Executor)this.taskExecutor);
    }

    private ListenableFuture<List<SyncTask>> createSyncTasks(ListenableFuture<List<InetAddressAndPort>> allSnapshotTasks, List<InetAddressAndPort> allEndpoints) {
        ListenableFuture validations = allSnapshotTasks != null ? Futures.transformAsync(allSnapshotTasks, endpoints -> {
            if (this.parallelismDegree == RepairParallelism.SEQUENTIAL) {
                return this.sendSequentialValidationRequest((Collection<InetAddressAndPort>)endpoints);
            }
            return this.sendDCAwareValidationRequest((Collection<InetAddressAndPort>)endpoints);
        }, (Executor)this.taskExecutor) : this.sendValidationRequest(allEndpoints);
        return Futures.transform((ListenableFuture)validations, (Function)(this.session.optimiseStreams && !this.session.pullRepair ? this::optimisedSyncing : this::standardSyncing), (Executor)this.taskExecutor);
    }

    private boolean isTransient(InetAddressAndPort ep) {
        return this.session.commonRange.transEndpoints.contains((Object)ep);
    }

    private List<SyncTask> standardSyncing(List<TreeResponse> trees) {
        return RepairJob.createStandardSyncTasks(this.desc, trees, FBUtilities.getLocalAddressAndPort(), this::isTransient, this.session.isIncremental, this.session.pullRepair, this.session.previewKind);
    }

    static List<SyncTask> createStandardSyncTasks(RepairJobDesc desc, List<TreeResponse> trees, InetAddressAndPort local, Predicate<InetAddressAndPort> isTransient, boolean isIncremental, boolean pullRepair, PreviewKind previewKind) {
        long startedAt = System.currentTimeMillis();
        ArrayList<SyncTask> syncTasks = new ArrayList<SyncTask>();
        for (int i = 0; i < trees.size() - 1; ++i) {
            TreeResponse r1 = trees.get(i);
            for (int j = i + 1; j < trees.size(); ++j) {
                SyncTask task;
                List<Range<Token>> differences;
                TreeResponse r2 = trees.get(j);
                if (isTransient.test(r1.endpoint) && isTransient.test(r2.endpoint) || (differences = MerkleTrees.difference(r1.trees, r2.trees)).isEmpty()) continue;
                if (r1.endpoint.equals(local) || r2.endpoint.equals(local)) {
                    boolean transferRanges;
                    TreeResponse self = r1.endpoint.equals(local) ? r1 : r2;
                    TreeResponse remote = r2.endpoint.equals(local) ? r1 : r2;
                    boolean requestRanges = !isTransient.test(self.endpoint);
                    boolean bl = transferRanges = !isTransient.test(remote.endpoint) && !pullRepair;
                    if (!requestRanges && !transferRanges) continue;
                    task = new LocalSyncTask(desc, self.endpoint, remote.endpoint, differences, isIncremental ? desc.parentSessionId : null, requestRanges, transferRanges, previewKind);
                } else if (isTransient.test(r1.endpoint) || isTransient.test(r2.endpoint)) {
                    TreeResponse streamFrom = isTransient.test(r1.endpoint) ? r1 : r2;
                    TreeResponse streamTo = isTransient.test(r1.endpoint) ? r2 : r1;
                    task = new AsymmetricRemoteSyncTask(desc, streamTo.endpoint, streamFrom.endpoint, differences, previewKind);
                } else {
                    task = new SymmetricRemoteSyncTask(desc, r1.endpoint, r2.endpoint, differences, previewKind);
                }
                syncTasks.add(task);
            }
            trees.get((int)i).trees.release();
        }
        trees.get((int)(trees.size() - 1)).trees.release();
        logger.info("Created {} sync tasks based on {} merkle tree responses for {} (took: {}ms)", new Object[]{syncTasks.size(), trees.size(), desc.parentSessionId, System.currentTimeMillis() - startedAt});
        return syncTasks;
    }

    private List<SyncTask> optimisedSyncing(List<TreeResponse> trees) {
        return RepairJob.createOptimisedSyncingSyncTasks(this.desc, trees, FBUtilities.getLocalAddressAndPort(), this::isTransient, this::getDC, this.session.isIncremental, this.session.previewKind);
    }

    @VisibleForTesting
    ListenableFuture<List<SyncStat>> executeTasks(List<SyncTask> tasks) {
        ActiveRepairService.instance.getParentRepairSession(this.desc.parentSessionId);
        this.syncTasks.addAll(tasks);
        for (SyncTask task : tasks) {
            if (!task.isLocal()) {
                this.session.trackSyncCompletion(Pair.create(this.desc, task.nodePair()), (CompletableRemoteSyncTask)((Object)task));
            }
            this.taskExecutor.submit((Runnable)task);
        }
        return Futures.allAsList(tasks);
    }

    static List<SyncTask> createOptimisedSyncingSyncTasks(RepairJobDesc desc, List<TreeResponse> trees, InetAddressAndPort local, Predicate<InetAddressAndPort> isTransient, java.util.function.Function<InetAddressAndPort, String> getDC, boolean isIncremental, PreviewKind previewKind) {
        long startedAt = System.currentTimeMillis();
        ArrayList<SyncTask> syncTasks = new ArrayList<SyncTask>();
        DifferenceHolder diffHolder = new DifferenceHolder(trees);
        logger.trace("diffs = {}", (Object)diffHolder);
        PreferedNodeFilter preferSameDCFilter = (streaming, candidates) -> candidates.stream().filter(node -> ((String)getDC.apply(streaming)).equals(getDC.apply((InetAddressAndPort)node))).collect(Collectors.toSet());
        ImmutableMap<InetAddressAndPort, HostDifferences> reducedDifferences = ReduceHelper.reduce(diffHolder, preferSameDCFilter);
        for (int i = 0; i < trees.size(); ++i) {
            InetAddressAndPort address = trees.get((int)i).endpoint;
            if (isTransient.test(address)) continue;
            HostDifferences streamsFor = (HostDifferences)reducedDifferences.get((Object)address);
            if (streamsFor != null) {
                Preconditions.checkArgument((boolean)streamsFor.get(address).isEmpty(), (Object)"We should not fetch ranges from ourselves");
                for (InetAddressAndPort fetchFrom : streamsFor.hosts()) {
                    ArrayList<Range<Token>> toFetch = new ArrayList<Range<Token>>(streamsFor.get(fetchFrom));
                    assert (!toFetch.isEmpty());
                    logger.trace("{} is about to fetch {} from {}", new Object[]{address, toFetch, fetchFrom});
                    SyncTask task = address.equals(local) ? new LocalSyncTask(desc, address, fetchFrom, toFetch, isIncremental ? desc.parentSessionId : null, true, false, previewKind) : new AsymmetricRemoteSyncTask(desc, address, fetchFrom, toFetch, previewKind);
                    syncTasks.add(task);
                }
                continue;
            }
            logger.trace("Node {} has nothing to stream", (Object)address);
        }
        logger.info("Created {} optimised sync tasks based on {} merkle tree responses for {} (took: {}ms)", new Object[]{syncTasks.size(), trees.size(), desc.parentSessionId, System.currentTimeMillis() - startedAt});
        logger.trace("Optimised sync tasks for {}: {}", (Object)desc.parentSessionId, syncTasks);
        return syncTasks;
    }

    private String getDC(InetAddressAndPort address) {
        return DatabaseDescriptor.getEndpointSnitch().getDatacenter(address);
    }

    private ListenableFuture<List<TreeResponse>> sendValidationRequest(Collection<InetAddressAndPort> endpoints) {
        String message = String.format("Requesting merkle trees for %s (to %s)", this.desc.columnFamily, endpoints);
        logger.info("{} {}", (Object)this.session.previewKind.logPrefix(this.desc.sessionId), (Object)message);
        Tracing.traceRepair(message, new Object[0]);
        int nowInSec = this.getNowInSeconds();
        ArrayList<ValidationTask> tasks = new ArrayList<ValidationTask>(endpoints.size());
        for (InetAddressAndPort endpoint : endpoints) {
            ValidationTask task = new ValidationTask(this.desc, endpoint, nowInSec, this.session.previewKind);
            tasks.add(task);
            this.session.trackValidationCompletion(Pair.create(this.desc, endpoint), task);
            this.taskExecutor.execute((Runnable)task);
        }
        return Futures.allAsList(tasks);
    }

    private ListenableFuture<List<TreeResponse>> sendSequentialValidationRequest(Collection<InetAddressAndPort> endpoints) {
        String message = String.format("Requesting merkle trees for %s (to %s)", this.desc.columnFamily, endpoints);
        logger.info("{} {}", (Object)this.session.previewKind.logPrefix(this.desc.sessionId), (Object)message);
        Tracing.traceRepair(message, new Object[0]);
        int nowInSec = this.getNowInSeconds();
        ArrayList<ValidationTask> tasks = new ArrayList<ValidationTask>(endpoints.size());
        LinkedList<InetAddressAndPort> requests = new LinkedList<InetAddressAndPort>(endpoints);
        InetAddressAndPort address = (InetAddressAndPort)requests.poll();
        ValidationTask firstTask = new ValidationTask(this.desc, address, nowInSec, this.session.previewKind);
        logger.info("{} Validating {}", (Object)this.session.previewKind.logPrefix(this.desc.sessionId), (Object)address);
        this.session.trackValidationCompletion(Pair.create(this.desc, address), firstTask);
        tasks.add(firstTask);
        ValidationTask currentTask = firstTask;
        while (requests.size() > 0) {
            final InetAddressAndPort nextAddress = (InetAddressAndPort)requests.poll();
            final ValidationTask nextTask = new ValidationTask(this.desc, nextAddress, nowInSec, this.session.previewKind);
            tasks.add(nextTask);
            Futures.addCallback((ListenableFuture)currentTask, (FutureCallback)new FutureCallback<TreeResponse>(){

                public void onSuccess(TreeResponse result) {
                    logger.info("{} Validating {}", (Object)((RepairJob)RepairJob.this).session.previewKind.logPrefix(((RepairJob)RepairJob.this).desc.sessionId), (Object)nextAddress);
                    RepairJob.this.session.trackValidationCompletion(Pair.create(RepairJob.this.desc, nextAddress), nextTask);
                    RepairJob.this.taskExecutor.execute((Runnable)nextTask);
                }

                public void onFailure(Throwable t) {
                }
            }, (Executor)MoreExecutors.directExecutor());
            currentTask = nextTask;
        }
        this.taskExecutor.execute((Runnable)firstTask);
        return Futures.allAsList(tasks);
    }

    private ListenableFuture<List<TreeResponse>> sendDCAwareValidationRequest(Collection<InetAddressAndPort> endpoints) {
        String message = String.format("Requesting merkle trees for %s (to %s)", this.desc.columnFamily, endpoints);
        logger.info("{} {}", (Object)this.session.previewKind.logPrefix(this.desc.sessionId), (Object)message);
        Tracing.traceRepair(message, new Object[0]);
        int nowInSec = this.getNowInSeconds();
        ArrayList<ValidationTask> tasks = new ArrayList<ValidationTask>(endpoints.size());
        HashMap<String, Queue> requestsByDatacenter = new HashMap<String, Queue>();
        for (InetAddressAndPort inetAddressAndPort : endpoints) {
            String dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(inetAddressAndPort);
            Queue queue = requestsByDatacenter.computeIfAbsent(dc, k -> new LinkedList());
            queue.add(inetAddressAndPort);
        }
        for (Map.Entry entry : requestsByDatacenter.entrySet()) {
            Queue requests = (Queue)entry.getValue();
            InetAddressAndPort address = (InetAddressAndPort)requests.poll();
            ValidationTask firstTask = new ValidationTask(this.desc, address, nowInSec, this.session.previewKind);
            logger.info("{} Validating {}", (Object)this.session.previewKind.logPrefix(this.session.getId()), (Object)address);
            this.session.trackValidationCompletion(Pair.create(this.desc, address), firstTask);
            tasks.add(firstTask);
            ValidationTask currentTask = firstTask;
            while (requests.size() > 0) {
                final InetAddressAndPort nextAddress = (InetAddressAndPort)requests.poll();
                final ValidationTask nextTask = new ValidationTask(this.desc, nextAddress, nowInSec, this.session.previewKind);
                tasks.add(nextTask);
                Futures.addCallback((ListenableFuture)currentTask, (FutureCallback)new FutureCallback<TreeResponse>(){

                    public void onSuccess(TreeResponse result) {
                        logger.info("{} Validating {}", (Object)((RepairJob)RepairJob.this).session.previewKind.logPrefix(RepairJob.this.session.getId()), (Object)nextAddress);
                        RepairJob.this.session.trackValidationCompletion(Pair.create(RepairJob.this.desc, nextAddress), nextTask);
                        RepairJob.this.taskExecutor.execute((Runnable)nextTask);
                    }

                    public void onFailure(Throwable t) {
                    }
                }, (Executor)MoreExecutors.directExecutor());
                currentTask = nextTask;
            }
            this.taskExecutor.execute((Runnable)firstTask);
        }
        return Futures.allAsList(tasks);
    }
}

