#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/soundlib.h>
#include "Mixer.h"

#define MIXER_FILE "/dev/sndmixer%i%i"

int main(int argc, char **argv)
{
	int card = 0, device = 0;
	char mixer_path[32];
	char device_name[64] = "";
	int32 exact, mute, unmute, norec, rec, left, right, flags, device_index;
	int32 left_dB, right_dB;
	int32 cur_left, cur_right, cur_flags;
	int count;
	int i,add;

	exact = mute = rec = norec = unmute = device_index = left = right = -1;
	left_dB = right_dB = -1;
	
	for (add = 0; add + 1 < argc; i++) {
		if (argv[add+1][0] == '-') {
			add++;
			if (argv[add][1] == 'c') {
				card = snd_card_name(argv[++add]);
				if (card < 0) {
					fprintf(stderr, "Invalid card: %s\n",argv[2]);
					exit(1);
				}
			} else if (argv[add][1] == 'd') {
				device = atoi(argv[++add]);
				if (device < 0 || device > 128) {
					fprintf(stderr, "Invalid device: %s\n",argv[2]);
					exit(1);
				}
			} else {
				fprintf(stderr, "Invalid option: %s\n", argv[add+1]);
				return 1;
			}
		} else {
			break;
		}
	}	
	for (i=1+add; i < argc; i++) {
		if (strcmp(argv[i],"exact")==0) {
			exact = 1;
		} else if (strcmp(argv[i],"mute")==0) {
			mute = 1;
		} else if (strcmp(argv[i],"unmute")==0) {
			unmute = 1;
		} else if (strcmp(argv[i],"rec")==0) {
			rec = 1;
		} else if (strcmp(argv[i],"norec")==0) {
			norec = 1;
		} else if (sscanf(argv[i], "%d:%d", &left, &right)==2) {
		} else if (sscanf(argv[i], "%d", &left)==1) {
			right = left;
		} else if (sscanf(argv[i], "%s", device_name)==1) {
		} else {
			fprintf(stderr, "Wrong keyword: %s\n", argv[i]);
			exit(1);
		}
	
	}
	sprintf(mixer_path, MIXER_FILE, card, device);
	Mixer mixer(card,device);
	
	if (mixer.Init() == false) {
		fprintf(stderr, "Failed to open mixer device\n");
		return 1;
	}
	count = mixer.NumDevices();
	
	for (i=0; i < count; i++) {
		mixer.DeviceSet(i);
		if (strcasecmp(device_name, mixer.Name())==0) 
		  device_index = i;
	}
	printf("Quick 'n Dirty (Recode It) Mixer v0.001 for ALSA Driver (C) 1998 Adnans\n\n");
	if (device_index >= 0) {
		mixer.DeviceSet(device_index);
		mixer.Read(&cur_left, &cur_right, &cur_flags);
		if (left >= 0) cur_left = left;
		if (right >= 0) cur_right = right;
		if (rec == 1) cur_flags |= E_MIXER_RECORD;
		else if (norec == 1) cur_flags &= ~E_MIXER_RECORD;
		if (mute == 1) cur_flags |= E_MIXER_MUTE;	
		else if (unmute == 1) cur_flags &= ~E_MIXER_MUTE;	
		if (left != -1 || rec != -1 || norec != -1 || mute != -1 || unmute != -1) {
			mixer.Write(cur_left, cur_right, cur_flags);
		}
		printf("%-16s", mixer.Name());
		mixer.Read(&left, &right, &flags);
		mixer.Read_dB(&left_dB, &right_dB);
		printf("%02d%% (%6.2fdB) : %02d%% (%6.2fdB) %s %s\n\n",
				left, ((float)left_dB) / 100.0,
				right, ((float)right_dB) / 100.0,
				(flags & E_MIXER_MUTE) ? "Mute" : "    ",
				(flags & E_MIXER_RECORD) ? "Rec" : "   " );
	} else {
		if (strlen(device_name))
		  printf("Device not found: %s\n\n", device_name);
		for (i=0; i < count; i++) {
			mixer.DeviceSet(i);
			printf("%-16s", mixer.Name());
			mixer.Read(&left, &right, &flags);
			mixer.Read_dB(&left_dB, &right_dB);
		        printf("%02d%% (%6.2fdB) : %02d%% (%6.2fdB) %s %s\n",
                               left, ((float)left_dB)/100.0, right, ((float)right_dB)/100.0,
			       (flags & E_MIXER_MUTE) ? "Mute" : "    ",
			       (flags & E_MIXER_RECORD) ? "Rec" : "   ");
		}
		printf("\nUsage: Mixer [-c card] [-d device] <device> [vol|left:right] [mute|unmute] [rec|norec]\n\n");
		return 1;
	}
	
	return 0;
}
