//---------------------------------------------------------------------------
//
// MIX_OBJS.C
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
// PURPOSE.
//
// Copyright (c) 1991 - 1995  Microsoft Corporation.  All Rights Reserved.
//
//---------------------------------------------------------------------------

#include <windows.h>

// stop compiler from griping about in-line

#pragma warning (disable:4704)

#define Not_VxD
#include <vmm.h>
#include <configmg.h>

#include <mmsystem.h>
#include <mmddk.h>
#include <mmreg.h>
#include <limits.h>

#include "mixstrng.h"
#include "drmpu401.h"//added for mixer
#include "mixer.h"

//
// These are the default definitions of the mixer "objects" for the
// AD1848J/K and CS4248 when using the WSS DAK (Hardware Developer's
// Assistance Kit) specifications.
//

// NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE!
//
// !!!!!!!!  DO NOT DEFINE THIS AS GLOBALS IN YOUR DATA SEGMENT.  !!!!!!!!
// !!!!!!!!          USE CODE SEGMENT BASED DATA INSTEAD          !!!!!!!!
//
// It is highly probable that your data segment is FIXED, this is
// unnecessary clutter and wasted valuable resources for simple data
// structures.  Define this "global" default information in your
// code segment (BCODE) and allocate the necessary memory (GMEM_MOVEABLE)
// to support your mixer device.
//
// !!!!!!!!  DO NOT DEFINE THIS AS GLOBALS IN YOUR DATA SEGMENT.  !!!!!!!!
// !!!!!!!!          USE CODE SEGMENT BASED DATA INSTEAD          !!!!!!!!
//
// NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE! NOTE!

//----
//
// control map (for more info see mixer.c)
//
// The first index is the control number.
// The first UINT is the dest #.
// The second UINT is the "relative" source #.
// The third is the # of channels for the control.
// When source # is -1, the control is "at the dest."
//
//----
UINT BCODE gauControlMap[ MAXCONTROLS ][ 3 ] = 
{
   // Mux controls

   {DEST_WAVEIN,     UINT_MAX,  1}, //Control 0

   //Volume controls

   {DEST_LINEOUT,           0,  2}, //Control 1
   {DEST_LINEOUT,           1,  2}, //Control 2
   {DEST_LINEOUT,           2,  2}, //Control 3
   {DEST_LINEOUT,    UINT_MAX,  1}, //Control 4
   {DEST_WAVEIN,            0,  2}, //Control 5
   {DEST_WAVEIN,            1,  2}, //Control 6

   //Mute controls

   {DEST_LINEOUT,           0,  1}, //Control 7
   {DEST_LINEOUT,           1,  1}, //Control 8
   {DEST_LINEOUT,           2,  1}, //Control 9
   {DEST_LINEOUT,    UINT_MAX,  1}, //Control 10
} ;

//
// The number of controls "at" a destination is the number of controls above
// that had a destination == x and relative source # of UINT_MAX.
// These consts are plugged into the DefaultCardObjects structure.
//

#define CONTROLS_AT_DEST0 2
#define CONTROLS_AT_DEST1 1
#define CONTROLS_AT_DEST2 1

//----
//
// source map (for more info see mixer.c)
//
// The first index is the dest#.
// The second is the "relative" source #.
// The value is the real source # (to copy the info struct for).
//
//----
UINT BCODE gauSourceMap[ MAXDESTINATIONS ][ MAXSOURCES ] =
{ 
   { SOURCE_AUX1, SOURCE_WAVEOUT, SOURCE_MIDIOUT, UINT_MAX },
   { SOURCE_AUDIO, SOURCE_MIX,     UINT_MAX,       UINT_MAX }
} ;

//----
//
// source controls map (for more info see mixer.c)
//
//
// The first index is the dest#.
// The second is the "relative" source #.
// The value is the # of controls at
// this source as connected to this dest.
//
//----

UINT BCODE gauSourceControlsMap[ MAXDESTINATIONS ][ MAXSOURCES ] =
{
   {  2,  2,  2,  0,  0 },
   {  1,  1,  0,  1,  1 }
} ;

//***************************************************************************
//
//___READTHIS__READTHIS__READTHIS__READTHIS__READTHIS__READTHIS__READTHIS___
//
//  Be VERY CAREFUL when defining the initializers for these structures.
//  MSVC/C++ has a known problem when initializing structures within
//  unions.  YOU _MUST_ define each element in largest structure (e.g.
//  both elements in a Bounds structure).  If you fail to do so, the
//  compiler may generate invalid structures including additional
//  padding (sometimes 32 bytes) at the end of these array elements.
//  Unfortunately, this causes each following array element to be
//  misaligned.  Guarantee your structure definitions are correct by
//  defining the necessary elements as demonstrated below.  Also, it is
//  wise to generate a .COD file using the -Fc option to verify that
//  additional padding is not erroneously generated.
//
//___READTHIS__READTHIS__READTHIS__READTHIS__READTHIS__READTHIS__READTHIS___
//
//***************************************************************************

//
// Source defaults...
//
MIXERLINE BCODE gmxlSources[ MAXSOURCES ] =
{
   // Source 0 - Aux1

   {
      sizeof(MIXERLINE),                     // cbStruct
      0,                                     // dwDestination
      SOURCE_AUX1,                           // dwSource
      (DWORD)-1L,                            // dwLineID
      MIXERLINE_LINEF_SOURCE,                // fdwLine
      0,                                     // dwUser
      MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY, // dwComponentType
      2,                                     // cChannels
      0,                                     // cConnections
      0,                                     // cControls
      "",
      "",
      {
            MIXERLINE_TARGETTYPE_UNDEFINED,
            0,      // target dwDeviceID
            0,      // target wMid
            0,      // target wPid
            0,      // target vDriverVersion
            { 0 }   // target szPname
      }
   },

   //Source1 - Wave Out
   {
      sizeof(MIXERLINE),                      // cbStruct
      0,                                      // dwDestination
      SOURCE_WAVEOUT,                         // dwSource
      (DWORD)-1L,                             // dwLineID
      MIXERLINE_LINEF_SOURCE,                 // fdwLine
      0,                                      // dwUser
      MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT,    // dwComponentType
      2,                                      // cChannels
      0,                                      // cConnections
      0,                                      // cControls
      "",
      "",
      {
            MIXERLINE_TARGETTYPE_WAVEOUT,
            0,      // target dwDeviceID
            0,      // target wMid
            0,      // target wPid
            0,      // target vDriverVersion
            { 0 }   // target szPname
      }
   },

   //Source2 - MidiOut
   {
      sizeof(MIXERLINE),                      // cbStruct
      0,                                      // dwDestination
      SOURCE_MIDIOUT,                         // dwSource
      (DWORD)-1L,                             // dwLineID
      MIXERLINE_LINEF_SOURCE,                 // fdwLine
      0,                                      // dwUser
      MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER,// dwComponentType
      2,                                      // cChannels
      0,                                      // cConnections
      0,                                      // cControls
      "",
      "",
      {
            MIXERLINE_TARGETTYPE_UNDEFINED,
            0,      // target dwDeviceID
            0,      // target wMid
            0,      // target wPid
            0,      // target vDriverVersion
            { 0 }   // target szPname
      }
   },

   //Source3 - Mix of lines >> Record
   {
      sizeof(MIXERLINE),                      // cbStruct
      0,                                      // dwDestination
      SOURCE_MIX,                             // dwSource
      (DWORD)-1L,                             // dwLineID
      MIXERLINE_LINEF_SOURCE,                 // fdwLine
      0,                                      // dwUser
      MIXERLINE_COMPONENTTYPE_SRC_LINE, // dwComponentType
      1,                                      // cChannels
      0,                                      // cConnections
      0,                                      // cControls
      "",
      "",
      {
            MIXERLINE_TARGETTYPE_UNDEFINED,
            0,      // target dwDeviceID
            0,      // target wMid
            0,      // target wPid
            0,      // target vDriverVersion
            { 0 }   // target szPname
      }
   },
      //Source4 - Audio in  >> Record
   {
      sizeof(MIXERLINE),                      // cbStruct
      0,                                      // dwDestination
      SOURCE_AUX1,                           // dwSource
      (DWORD)-1L,                             // dwLineID
      MIXERLINE_LINEF_SOURCE,                 // fdwLine
      0,                                      // dwUser
      MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY, // dwComponentType
      1,                                      // cChannels
      0,                                      // cConnections
      0,                                      // cControls
      "",
      "",
      {
            MIXERLINE_TARGETTYPE_UNDEFINED,
            0,      // target dwDeviceID
            0,      // target wMid
            0,      // target wPid
            0,      // target vDriverVersion
            { 0 }   // target szPname
      }
   }
} ;

//
// Destination defaults...
//

//***************************************************************************
//
//___READTHIS__READTHIS__READTHIS__READTHIS__READTHIS__READTHIS__READTHIS___
//
//    The destinations are inactive until a source on that destination
//    becomes active.  When a source at this destination becomes active
//    (e.g. wave-in is started for that selected source), the source @
//    that destination then becomes active and the destination becomes
//    active.
//
//    When a destination has a "persistent" source, such as line-in, the
//    destination is always active, unless this connection can be
//    selected using a mux or mixer - the destination then becomes active
//    when that the connection through the mux or mixer is enabled.
//
//___READTHIS__READTHIS__READTHIS__READTHIS__READTHIS__READTHIS__READTHIS___
//
//***************************************************************************

MIXERLINE BCODE gmxlDests[ MAXDESTINATIONS ] =
{
   // Destination0 - LineOut
   {
      sizeof(MIXERLINE),                     // cbStruct
      DEST_LINEOUT,                          // dwDestination
      0,                                     // dwSource
      (DWORD)-1L,                            // dwLineID
      0,                                     // fdwLine
      0,                                     // dwUser
      MIXERLINE_COMPONENTTYPE_DST_SPEAKERS,  // dwComponentType
      1,                                     // cChannels
      3,                                     // cConnections
      CONTROLS_AT_DEST0,                     // cControls
      "",
      "",
      {
            MIXERLINE_TARGETTYPE_UNDEFINED,     
            0,                               // target dwDeviceID
            0,                               // target wMid
            0,                               // target wPid
            0,                               // target vDriverVersion
            { 0 }                            // target szPname
      }
   },

   // Destination 1 - WaveIn

   {
      sizeof(MIXERLINE),                     // cbStruct
      DEST_WAVEIN,                           // dwDestination
      0,                                     // dwSource
      (DWORD)-1L,                            // dwLineID
      0,                                     // fdwLine
      0,                                     // dwUser
      MIXERLINE_COMPONENTTYPE_DST_WAVEIN,    // dwComponentType
      2,                                     // cChannels
      2,                                     // cConnections
      CONTROLS_AT_DEST1,                     // cControls
      "",
      "",
      {
            MIXERLINE_TARGETTYPE_WAVEIN,
            0,                               // target dwDeviceID
            0,                               // target wMid
            0,                               // target wPid
            0,                               // target vDriverVersion
            { 0 }                            // target szPname
      }
   }
} ;

//
// Control defaults...
//
MIXERCONTROL BCODE gmxc[ MAXCONTROLS ] =
{
   // Control 0 - Mux that feeds Wavein

   {
      sizeof(MIXERCONTROL),               // cbStruct
      MUX_WAVEIN,                         // dwControlID
      MIXERCONTROL_CONTROLTYPE_MUX,       // dwControlType
      MIXERCONTROL_CONTROLF_MULTIPLE |
      MIXERCONTROL_CONTROLF_UNIFORM,      // fdwControl
      2,                                  // cMultipleItems
      "WaveInMux",                        // szShortName
      "Wave Input Mux",                   // szName
      {
         {
            0,                            // Bounds.dwMinimum
            1                             // Bounds.dwMaximum
         }
      },
      {
            1                             // Metrics
      }
   },

   // Control 1 -  Vol @ between Aux1 and Lineout

   {
      sizeof(MIXERCONTROL),               // cbStruct    
      VOL_OUTAUX1,                        // dwControlID
      MIXERCONTROL_CONTROLTYPE_VOLUME,    // dwControlType
      0,                                  // fdwControl
      0,                                  // cMultipleItems
      "LineInVol",                        // szShortName
      "Volume Control for Line Input",    // szName
      {
         {
            0,                            // Bounds.dwMinimum
            0xFFFF                        // Bounds.dwMaximum
         }
      },
      {
            16                              // Metrics.cSteps
      }
   },

   //Control2     - DAC output attenuation
   {
      sizeof(MIXERCONTROL),               // cbStruct    
      VOL_OUTDAC,                         // dwControlID
      MIXERCONTROL_CONTROLTYPE_VOLUME,    // dwControlType
      0,                                  // fdwControl
      0,                                  // cMultipleItems
      "WaveOutVol",                       // szShortName
      "Volume for Wave Out",              // szName
      {
         {
            0,                              // Bounds.dwMinimum
            0xFFFF                          // Bounds.dwMaximum
         }
      },
      {
            64                              // Metrics.cSteps
      }
   },

   //Control3     - Midi out volume
   {
      sizeof(MIXERCONTROL),               // cbStruct    
      VOL_OUTMIDI,                        // dwControlID
      MIXERCONTROL_CONTROLTYPE_VOLUME,    // dwControlType
      0,                                  // fdwControl
      0,                                  // cMultipleItems
      "MidiOutVol",                       // szShortName
      "Volume Control for MIDI Out",      // szName
      {
         {
            0,                              // Bounds.dwMinimum
            0xFFFF                          // Bounds.dwMaximum
         }
      },
      {
            64                              // Metrics.cSteps
      }
   },

   //Control4     -  "Master Output Volume"
   {
      sizeof(MIXERCONTROL),           // cbStruct    
      VOL_OUTLINE,                    // dwControlID
      MIXERCONTROL_CONTROLTYPE_VOLUME,// dwControlType
      0,                              // fdwControl
      0,                              // cMultipleItems
      "LineOutVol",                   // szShortName
      "Volume for Line Out",          // szName
      {
         {
            0x0,                     // Bounds.dwMinimum//toto
            0xFFFF,                     // Bounds.dwMaximum
         }
      },
      {
            16                          // Metrics.cSteps
      }
   },

   //Control5 -  Vol between Aux1 & Wavein 
   {
      sizeof(MIXERCONTROL),           // cbStruct    
      VOL_W_INAUX1,                   // dwControlID
      MIXERCONTROL_CONTROLTYPE_VOLUME,// dwControlType
      0,                              // fdwControl
      0,                              // cMultipleItems
      "LineInVol",                    // szShortName
      "Volume for Line In",           // szName
      {
            0,                          // Bounds.dwMinimum
            0xFFFF                      // Bounds.dwMaximum
      },
      {
            16                          // Metrics.cSteps
      }
   },

   //Control6 - Vol between the Mix & Wavein
   {
      sizeof(MIXERCONTROL),           // cbStruct    
      VOL_W_INMIX,                    // dwControlID
      MIXERCONTROL_CONTROLTYPE_VOLUME,// dwControlType
      0,                              // fdwControl
      0,                              // cMultipleItems
      "MixVol",                       // szShortName
      "Volume for Mix",        // szName
      {
            0,                          // Bounds.dwMinimum
            0xFFFF                      // Bounds.dwMaximum
      },
      {
            16                          // Metrics.cSteps
      }
   },

   //Control7     - Mute of Aux1 output
   {
      sizeof(MIXERCONTROL),           // cbStruct    
      MUTE_OUTAUX1,                   // dwControlID
      MIXERCONTROL_CONTROLTYPE_MUTE,  // dwControlType
      MIXERCONTROL_CONTROLF_UNIFORM,  // fdwControl
      0,                              // cMultipleItems
      "LineInMute",                   // szShortName
      "Mute of Line Input",           // szName
      {
            0,                          // Bounds.dwMinimum
            1                           // Bounds.dwMaximum
      },
      {
            0                           // Metrics
      }
   },

   //Control8     - Mute of DAC (wave-out) output
   {
      sizeof(MIXERCONTROL),           // cbStruct    
      MUTE_OUTDAC,                    // dwControlID
      MIXERCONTROL_CONTROLTYPE_MUTE,  // dwControlType
      MIXERCONTROL_CONTROLF_UNIFORM,  // fdwControl
      0,                              // cMultipleItems
      "WaveOutMute",                  // szShortName
      "Mute of Wave Player",          // szName
      {
            0,                          // Bounds.dwMinimum
            1                           // Bounds.dwMaximum
      },
      {
            0                           // Metrics
      }
   },

   //Control9     - Mute of MIDI output
   {
      sizeof(MIXERCONTROL),           // cbStruct    
      MUTE_OUTMIDI,                   // dwControlID
      MIXERCONTROL_CONTROLTYPE_MUTE,  // dwControlType
      MIXERCONTROL_CONTROLF_UNIFORM,  // fdwControl
      0,                              // cMultipleItems
      "MidiMute",                     // szShortName
      "Mute of Midi Output",          // szName
      {
            0,                          // Bounds.dwMinimum
            1                           // Bounds.dwMaximum
      },
      {
            0                           // Metrics
      }
   },

   //Control10     - Mute of mixed DAC output 
   {
      sizeof(MIXERCONTROL),           // cbStruct    
      MUTE_OUTLINE,                   // dwControlID
      MIXERCONTROL_CONTROLTYPE_MUTE,  // dwControlType
      MIXERCONTROL_CONTROLF_UNIFORM,     // fdwControl
      0,                              // cMultipleItems
      "LineOutMute",                  // szShortName
      "Mute of Line Output",          // szName
      {
            0,                          // Bounds.dwMinimum
            1                           // Bounds.dwMaximum
      },
      {
            0                           // Metrics
      }
   },
} ;
