/****************************************************************************
 *
 *   midiout.c
 *
 *   Copyright (c) 1991-1992 Microsoft Corporation.  All Rights Reserved.
 *
 ***************************************************************************/

#include <windows.h>
#include <mmsystem.h>
#include <mmddk.h>
#include "dream94.h"

/*****************************************************************************
 * @doc INTERNAL
 *
 * @api void | modGetDevCaps | Get the capabilities of the port.
 *
 * @parm LPBYTE | lpCaps | Far pointer to a MIDIOUTCAPS structure.
 *
 * @parm WORD | wSize | Size of the MIDIOUTCAPS structure.
 *
 * @rdesc There is no return value.
 ****************************************************************************/
void FAR PASCAL modGetDevCaps(MDEVICECAPSEX FAR * lpCaps,WORD id)
{
MIDIOUTCAPS mc;

    mc.wMid = Mid;
    mc.wPid = MoPid;
    mc.vDriverVersion = DRIVER_VERSION;
    mc.wTechnology = MOD_MIDIPORT;
    mc.wVoices = 32;                   /* not used for ports */
    mc.wNotes = 64;                    /* not used for ports */
    mc.wChannelMask = 0xFFFF;         /* all channels */
    mc.dwSupport = MIDICAPS_VOLUME | MIDICAPS_LRVOLUME;
    LoadString(ghModule, IDS_DREAMMIDIOUT+id, mc.szPname, MAXPNAMELEN);

    MemCopy(lpCaps->pCaps, &mc, min((UINT) lpCaps -> cbSize,sizeof(mc)));
}
