/****************************************************************************
 *
 *   config.c
 *
 *   Copyright (c) 1991-1992 Microsoft Corporation.  All Rights Reserved.
 *
 ***************************************************************************/

#include <windows.h>
#include <mmsystem.h>
#include "dream94.h"

static char _based(_segname("_CODE")) aszHexFormat[] = "%X";
static char _based(_segname("_CODE")) aszIntFormat[] = "%d";

/*****************************************************************************

    internal function prototypes

 ****************************************************************************/ 

static int NEAR PASCAL PortToId(WORD wPort)
{
    switch(wPort) {
        case 0x300:  return IDC_300;
        case 0x320:  return IDC_320;
        case 0x330:  return IDC_330;
        case 0x332:  return IDC_332;
        case 0x334:  return IDC_334;
        case 0x336:  return IDC_336;
        default:     return -1;
    }                              
}

static WORD NEAR PASCAL IdToPort(int id)
{
    switch(id) {
        case IDC_300:  return 0x300;
        case IDC_320:  return 0x320;
        case IDC_330:  return 0x330;
        case IDC_332:  return 0x332;
        case IDC_334:  return 0x334;
        case IDC_336:  return 0x336;
        default:       return (WORD)-1;
    }
}

static int NEAR PASCAL IntToId(BYTE bInt)
{
    switch(bInt) {
        case 2:  return IDC_2;
        case 9:  return IDC_2; 
        case 5:  return IDC_5; 
        case 7:  return IDC_7;   
        case 10:  return IDC_10; 
        default: return -1;
    }
}

static BYTE NEAR PASCAL IdToInt(int id)
{
    switch(id) {
        case IDC_2:  return 9; 
        case IDC_5:  return 5;
        case IDC_7:  return 7;   
        case IDC_10:  return 10;
        default:     return (BYTE)-1;
    }
}

/***************************************************************************/

static void NEAR PASCAL ConfigErrorMsgBox(HWND hDlg, WORD wStringId)
{
char szErrorBuffer[MAX_ERR_STRING];    /* buffer for error messages */

    LoadString(ghModule, wStringId, szErrorBuffer, sizeof(szErrorBuffer));
    MessageBox(hDlg, szErrorBuffer, STR_PRODUCTNAME, MB_OK|MB_ICONEXCLAMATION);
}

/***************************************************************************/

void FAR PASCAL ConfigRemove(void)
{
    WritePrivateProfileString(STR_DRIVERNAME, NULL, NULL, STR_INIFILE);
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api int | Config | This puts up the configuration dialog box.
 *
 * @parm HWND | hWnd | Our Window handle.
 *
 * @parm HANDLE | hInstance | Our instance handle.
 *
 * @rdesc Returns whatever was returned from the dialog box procedure.
 ***************************************************************************/
int FAR PASCAL Config(HWND hWnd, HANDLE hInstance)
{
    return DialogBox(hInstance, MAKEINTATOM(DLG_CONFIG), hWnd, (FARPROC)ConfigDlgProc);
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | GetPortAndInt | Determines which port and interrupt settings
 *     the user has chosen in the configuration dialog box.
 *
 * @parm HWND | hDlg | Handle to the configuration dialog box.
 *
 * @rdesc HIWORD = new interrupt, LOWORD = new port
 ***************************************************************************/
static DWORD NEAR PASCAL GetPortAndInt(HWND hDlg)
{
WORD wNewPort   = -1;       /* new port chosen by user in config box */
BYTE bNewInt    = -1;       /* new interrupt chosen */
int  id;

    for (id = IDC_FIRSTPORT; id <= IDC_LASTPORT; id++)
        if (IsDlgButtonChecked(hDlg, id)) {
            wNewPort = IdToPort(id);
            break;
        }

    for (id = IDC_FIRSTINT; id <= IDC_LASTINT; id++)
        if (IsDlgButtonChecked(hDlg, id)) {
            bNewInt = IdToInt(id);
            break;
        }

    return MAKELONG(wNewPort, bNewInt);
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api int | ConfigDlgProc | Dialog proc for the configuration dialog box.
 *
 * @parm HWND | hDlg | Handle to the configuration dialog box.
 *
 * @parm WORD | msg | Message sent to the dialog box.
 *
 * @parm WORD | wParam | Message dependent parameter.
 *
 * @parm LONG | lParam | Message dependent parameter.
 *
 * @rdesc Returns DRV_RESTART if the user has changed settings, which will
 *     cause the drivers applet which launched this to give the user a
 *     message about having to restart Windows for the changes to take
 *     effect.  If the user clicks on "Cancel" or if no settings have changed,
 *     DRV_CANCEL is returned.
 ***************************************************************************/
int FAR PASCAL _loadds ConfigDlgProc(HWND hDlg, WORD msg, WORD wParam, LONG lParam)
{
char    buf[20];            /* buffer to write profile string into */
DWORD   dw;                 /* return value from GetPortAndInt */
WORD    wNewPort;           /* new port chosen by user in config box */
BYTE    bNewInt;            /* new interrupt chosen */
BYTE    bNewDMAChannel;     /* new DMA channel chosen */
int     id;

    switch (msg) {
        case WM_INITDIALOG:
            bNewInt = ConfigGetIRQ();
            wNewPort = ConfigGetPortBase();

            if ((id = PortToId(wNewPort)) == -1) id=IDC_330;
            CheckRadioButton(hDlg, IDC_FIRSTPORT, IDC_LASTPORT, id);

            if ((id = IntToId(bNewInt)) == -1)  id=IDC_2;
            CheckRadioButton(hDlg, IDC_FIRSTINT, IDC_LASTINT, id);
            break;

        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    dw = GetPortAndInt(hDlg);
                    wNewPort = LOWORD(dw);
                    bNewInt  = (BYTE)HIWORD(dw);

                    /*  we don't have a config option for DMA channel */
                    /*  so use the current setting */
                 //   bNewDMAChannel = (BYTE)(HIWORD(InitGetConfiguration())>>8);

                    /*  verify settings - if this fails, DO NOT WRITE INI */
                    /*  SETTINGS! */
                    if (LOWORD(dw = InitVerifyConfiguration(wNewPort, bNewInt)))
                    {
                        ConfigErrorMsgBox(hDlg, LOWORD(dw));
                        break;
                    }

                    /* settings are valid, so write them out */
                    wsprintf(buf, aszHexFormat, wNewPort);
                    WritePrivateProfileString(STR_DRIVERNAME, STR_PORT, buf, STR_INIFILE);
                    wsprintf(buf, aszIntFormat, bNewInt);
                    WritePrivateProfileString(STR_DRIVERNAME, STR_INT, buf, STR_INIFILE);

                    dw = InitGetConfiguration();
                    if ((wNewPort != LOWORD(dw))||(bNewInt != (BYTE)HIWORD(dw)))
                        EndDialog(hDlg, DRVCNF_RESTART);
                    else
                        EndDialog(hDlg, DRVCNF_CANCEL);
                    break;

                case IDCANCEL:
                    EndDialog(hDlg, DRVCNF_CANCEL);
                    break;

                case IDC_300:
                case IDC_320:
                case IDC_330:
                case IDC_332:
                case IDC_334:
                case IDC_336:
                    CheckRadioButton(hDlg, IDC_FIRSTPORT, IDC_LASTPORT, wParam);
                    break;

                case IDC_2:  
                case IDC_5: 
                case IDC_7: 
                case IDC_10:
                    CheckRadioButton(hDlg, IDC_FIRSTINT, IDC_LASTINT, wParam);
                    break;

                default:
                    break;
            }
            break;

        default:
            return FALSE;
    }

    return TRUE;
}
