/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 */

#include "driver.h"
#include "pcm.h"
#include "mixer.h"
#include "gus.h"

void snd_gf1_dma_program( snd_gus_card_t *gus,
			  unsigned int addr, 
			  const void *buf, 
			  unsigned int count, 
                          unsigned int cmd )
{
  unsigned long flags;
  unsigned int address;
  unsigned char dma_cmd;
  unsigned int address_high;

#if 0
  PRINTK( "dma_transfer: addr=0x%x, buf=0x%lx, count=0x%x\n", addr, (long)buf, count );
#endif

  if ( gus -> gf1.dma1 > 3 ) {
    if ( gus -> gf1.enh_mode ) {
      address = addr >> 1;
    } else {
      if ( addr & 0x1f ) {
        PRINTD( "snd_gf1_dma_transfer: unaligned address (0x%x)?\n", addr );
        return;
      }
      address = (addr & 0x000c0000) | ( (addr & 0x0003ffff) >> 1 );
    }
  } else {
    address = addr;
  }
    
  dma_cmd = SND_GF1_DMA_ENABLE | (unsigned short)cmd;
  if ( dma_cmd & SND_GF1_DMA_16BIT )  {
    count++; count &= ~1;			/* align */
  }
  if ( gus -> gf1.dma1 > 3 ) {
    dma_cmd |= SND_GF1_DMA_WIDTH16;
    count++; count &= ~1;			/* align */
  }
  CLI( &flags );
  snd_gf1_write8( gus, SND_GF1_GB_DRAM_DMA_CONTROL, 0 );  /* disable GF1 DMA */
  snd_gf1_look8( gus, SND_GF1_GB_DRAM_DMA_CONTROL );
  STI( &flags );
  snd_dma_program( gus -> gf1.dma1, buf, count, dma_cmd & SND_GF1_DMA_READ ? DMA_MODE_READ : DMA_MODE_WRITE );
#if 0
  PRINTK( "address = 0x%x, count = 0x%x, dma_cmd = 0x%x\n", address << 1, count, dma_cmd );
#endif
#if 0
  PRINTK( "jiffies = %li, used = %i, bpos = %i (%i)\n", jiffies, gus -> gf1.dma_used, gus -> gf1.pcm_bpos, gus -> pcm -> playback.block_lock );
#endif
  CLI( &flags );
  if ( gus -> gf1.enh_mode )
    {
      address_high = ((address >> 16) & 0x000000f0) | (address & 0x0000000f);
      snd_gf1_write16( gus, SND_GF1_GW_DRAM_DMA_LOW, (unsigned short)(address >> 4) );
      snd_gf1_write8( gus, SND_GF1_GB_DRAM_DMA_HIGH, (unsigned char)address_high );
    }
   else
    snd_gf1_write16( gus, SND_GF1_GW_DRAM_DMA_LOW, (unsigned short)(address >> 4) );
  snd_gf1_write8( gus, SND_GF1_GB_DRAM_DMA_CONTROL, dma_cmd );
  STI( &flags );
}

void snd_gf1_dma_ack( snd_gus_card_t *gus )
{
  snd_gf1_i_write8( gus, SND_GF1_GB_DRAM_DMA_CONTROL, 0x00 );
}

static void snd_gf1_dma_interrupt( snd_gus_card_t *gus )
{
  unsigned long flags;
  void *buffer;
  unsigned int addr, count, cmd;

  snd_gf1_dma_ack( gus );
  CLI( &flags );
  if ( --gus -> gf1.dma_used <= 0 ) {
    gus -> gf1.dma_flags &= ~1;
    STI( &flags );
    return;
  }
  buffer = gus -> gf1.dma_data[ gus -> gf1.dma_tail ].buffer;
  addr = gus -> gf1.dma_data[ gus -> gf1.dma_tail ].addr;
  count = gus -> gf1.dma_data[ gus -> gf1.dma_tail ].count;
  cmd = gus -> gf1.dma_data[ gus -> gf1.dma_tail ].cmd;
  gus -> gf1.dma_tail++;
  gus -> gf1.dma_tail %= gus -> gf1.dma_blocks;
  STI( &flags );
  snd_gf1_dma_program( gus, addr, buffer, count, (unsigned short)cmd );
#if 0
  printk( "program dma (IRQ) - addr = 0x%x, buffer = 0x%lx, count = 0x%x, cmd = 0x%x\n", addr, (long)buffer, count, cmd );
#endif
}

int snd_gf1_dma_init( snd_gus_card_t *gus )
{
  MUTEX_DOWN( gus, dma );
  gus -> gf1.dma_shared++;
  if ( gus -> gf1.dma_shared > 1 ) {
    MUTEX_UP( gus, dma );
    return 0;
  }    
  gus -> gf1.dma_flags = 0;
  gus -> gf1.dma_blocks = 1024;
  gus -> gf1.dma_data = snd_malloc( sizeof( snd_gf1_dma_block_t ) * gus -> gf1.dma_blocks );
  gus -> gf1.dma_head =
  gus -> gf1.dma_tail =
  gus -> gf1.dma_used = 0;
  if ( gus -> gf1.dma_data == NULL ) {
    gus -> gf1.dma_shared--;
    MUTEX_UP( gus, dma );
    return -ENOMEM;
  }
  gus -> gf1.interrupt_handler_dma_write = snd_gf1_dma_interrupt;
  MUTEX_UP( gus, dma );
  return 0;
}

int snd_gf1_dma_done( snd_gus_card_t *gus )
{
  MUTEX_DOWN( gus, dma );
  gus -> gf1.dma_shared--;
  if ( !gus -> gf1.dma_shared ) {
    snd_gf1_set_default_handlers( gus, SND_GF1_HANDLER_DMA_WRITE );
    snd_free( gus -> gf1.dma_data, sizeof( snd_gf1_dma_block_t ) * gus -> gf1.dma_blocks );
    gus -> gf1.dma_data = NULL;
  }
  MUTEX_UP( gus, dma );
  return 0;
}

int snd_gf1_dma_transfer_block( snd_gus_card_t *gus,
                                unsigned int addr,
                                void *buffer,
                                unsigned int count,
                                unsigned int cmd )
{
  unsigned long flags;

  CLI( &flags );
  if ( gus -> gf1.dma_used >= gus -> gf1.dma_blocks ) {
    STI( &flags );
    PRINTK( "sound: gf1 - dma block buffer full (%i)!!!\n", gus -> gf1.dma_blocks );
    return -ENOMEM;
  }                  
  gus -> gf1.dma_data[ gus -> gf1.dma_head ].buffer = buffer;
  gus -> gf1.dma_data[ gus -> gf1.dma_head ].addr = addr;
  gus -> gf1.dma_data[ gus -> gf1.dma_head ].count = count;
  gus -> gf1.dma_data[ gus -> gf1.dma_head ].cmd = cmd; 
  gus -> gf1.dma_head++;
  gus -> gf1.dma_head %= gus -> gf1.dma_blocks;
  gus -> gf1.dma_used++;
  if ( !(gus -> gf1.dma_flags & 1) ) {
    gus -> gf1.dma_flags |= 1;
    buffer = gus -> gf1.dma_data[ gus -> gf1.dma_tail ].buffer;
    addr = gus -> gf1.dma_data[ gus -> gf1.dma_tail ].addr;
    count = gus -> gf1.dma_data[ gus -> gf1.dma_tail ].count;
    cmd = gus -> gf1.dma_data[ gus -> gf1.dma_tail ].cmd;
    gus -> gf1.dma_tail++;
    gus -> gf1.dma_tail %= gus -> gf1.dma_blocks;
    STI( &flags );
    snd_gf1_dma_program( gus, addr, buffer, count, (unsigned short)cmd );
#if 0
    printk( "transfer block: addr = 0x%x, buffer = 0x%lx, count = 0x%x, cmd = 0x%x, dma_used = %i\n", addr, (long)buffer, count, cmd, gus -> gf1.dma_used );
#endif
    return 0;
  }
  STI( &flags );
  return 0;
}
